/*
 * Decompiled with CFR 0.152.
 */
package com.mikitellurium.turtlecharginstation.blockentity;

import com.mikitellurium.turtlecharginstation.block.ThunderchargeDynamoBlock;
import com.mikitellurium.turtlecharginstation.registry.ModBlockEntities;
import com.mikitellurium.turtlecharginstation.registry.ModTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import org.jetbrains.annotations.NotNull;

public class ThunderchargeDynamoBlockEntity
extends BlockEntity {
    private int charge = 0;
    public static ForgeConfigSpec.IntValue TRANSFER_RATE;
    public static ForgeConfigSpec.IntValue RECHARGE_AMOUNT;

    public ThunderchargeDynamoBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModBlockEntities.THUNDERCHARGE_DYNAMO.get(), blockPos, blockState);
    }

    public static void tick(Level level, BlockPos blockPos, BlockState blockState, ThunderchargeDynamoBlockEntity dynamo) {
        if (level.f_46443_) {
            return;
        }
        if (dynamo.charge > 0) {
            for (Direction direction : Direction.values()) {
                BlockEntity be;
                if (direction == Direction.UP || (be = ThunderchargeDynamoBlockEntity.maybeFindAdjacentBlockEntity(level, blockPos, direction)) == null || !be.getCapability(ForgeCapabilities.ENERGY).isPresent()) continue;
                be.getCapability(ForgeCapabilities.ENERGY).ifPresent(energyStorage -> energyStorage.receiveEnergy(((Integer)TRANSFER_RATE.get()).intValue(), false));
            }
            level.m_46597_(blockPos, (BlockState)blockState.m_61124_((Property)ThunderchargeDynamoBlock.POWERED, (Comparable)Boolean.valueOf(true)));
            --dynamo.charge;
        } else {
            level.m_46597_(blockPos, (BlockState)blockState.m_61124_((Property)ThunderchargeDynamoBlock.POWERED, (Comparable)Boolean.valueOf(false)));
        }
        ThunderchargeDynamoBlockEntity.m_155232_((Level)level, (BlockPos)blockPos, (BlockState)blockState);
    }

    private static BlockEntity maybeFindAdjacentBlockEntity(Level level, BlockPos pos, Direction direction) {
        BlockPos.MutableBlockPos mutable$pos = pos.m_121945_(direction).m_122032_();
        while (true) {
            if (level.m_7702_((BlockPos)mutable$pos) != null) {
                return level.m_7702_((BlockPos)mutable$pos);
            }
            if (!level.m_8055_((BlockPos)mutable$pos).m_204336_(ModTags.DYNAMO_CONDUCTIVE_BLOCKS)) break;
            mutable$pos.m_122173_(direction);
        }
        return null;
    }

    public int getCharge() {
        return this.charge;
    }

    public static void recharge(ThunderchargeDynamoBlockEntity dynamo) {
        dynamo.charge = Math.min(dynamo.getCharge() + (Integer)RECHARGE_AMOUNT.get(), Integer.MAX_VALUE);
    }

    public void m_142466_(@NotNull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.charge = nbt.m_128451_("charge");
    }

    protected void m_183515_(CompoundTag nbt) {
        nbt.m_128405_("charge", this.charge);
        super.m_183515_(nbt);
    }
}

