/*
 * Decompiled with CFR 0.152.
 */
package com.mikitellurium.turtlecharginstation.gui.element;

import com.mikitellurium.turtlecharginstation.util.SimpleSprite;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.energy.EnergyStorage;

public class EnergyStorageElement {
    private final SimpleSprite sprite;
    private final EnergyStorage energyStorage;
    private final Rect2i area;

    public EnergyStorageElement(EnergyStorage energyStorage, SimpleSprite texture, int xPos, int yPos, int width, int height) {
        this.sprite = texture;
        this.energyStorage = energyStorage;
        this.area = new Rect2i(xPos, yPos, width, height);
    }

    public void draw(GuiGraphics graphics) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.sprite.getTexture());
        graphics.m_280163_(this.sprite.getTexture(), this.area.m_110085_(), this.area.m_110086_(), 0.0f, 0.0f, this.area.m_110090_(), this.area.m_110091_(), this.sprite.getWidth(), this.sprite.getHeight());
        this.drawEnergyLevel(graphics);
    }

    private void drawEnergyLevel(GuiGraphics graphics) {
        graphics.m_280163_(this.sprite.getTexture(), this.area.m_110085_(), this.area.m_110086_() + this.getEnergyLevel(), 18.0f, (float)this.getEnergyLevel(), this.area.m_110090_(), this.area.m_110091_() - this.getEnergyLevel(), this.sprite.getWidth(), this.sprite.getHeight());
    }

    private int getEnergyLevel() {
        return this.sprite.getHeight() - (int)Math.floor((float)this.area.m_110091_() * ((float)this.energyStorage.getEnergyStored() / (float)this.energyStorage.getMaxEnergyStored()));
    }

    public List<Component> getTooltips() {
        return List.of(Component.m_237113_((String)(this.energyStorage.getEnergyStored() + "/" + this.energyStorage.getMaxEnergyStored() + " FE")));
    }

    public Rect2i getArea() {
        return this.area;
    }
}

