/*
 * Decompiled with CFR 0.152.
 */
package com.mikitellurium.turtlecharginstation.gui.element;

import com.mikitellurium.turtlecharginstation.blockentity.TurtleChargingStationBlockEntity;
import dan200.computercraft.shared.ModRegistry;
import dan200.computercraft.shared.turtle.blocks.TurtleBlockEntity;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.core.Direction;
import net.minecraft.util.FastColor;
import net.minecraft.world.level.block.entity.BlockEntity;

public class TurtleInfoElement {
    private final TurtleChargingStationBlockEntity charger;
    private final Rect2i area;
    private final int width = 100;
    private final int height = 80;
    private final Font font;
    private final int white;

    public TurtleInfoElement(TurtleChargingStationBlockEntity charger, int xPos, int yPos) {
        this.font = Minecraft.m_91087_().f_91062_;
        this.white = FastColor.ARGB32.m_13660_((int)255, (int)255, (int)255, (int)255);
        this.area = new Rect2i(xPos, yPos, 100, 80);
        this.charger = charger;
    }

    public void draw(GuiGraphics graphics) {
        int x = this.area.m_110085_();
        int y = this.area.m_110086_();
        graphics.m_280137_(this.font, "Name", x + 55, y + 1, this.white);
        graphics.m_280488_(this.font, "Fuel Level", x + this.area.m_110090_() - 14, y + 1, this.white);
        int h = y;
        for (Direction direction : Direction.values()) {
            graphics.m_280488_(this.font, this.getDirectionString(direction), this.alignString(this.getDirectionString(direction), x), h += 12, this.white);
            graphics.m_280137_(this.font, TurtleData.getAdjacentTurtleName(this.charger, direction), x + 55, h, TurtleData.getAdjacentTurtleColor(this.charger, direction));
            graphics.m_280137_(this.font, this.getFuelString(TurtleData.getAdjacentTurtleFuel(this.charger, direction)), x + 110, h, this.white);
        }
    }

    private String getDirectionString(Direction direction) {
        switch (direction.m_122433_()) {
            case "down": {
                return " Down:";
            }
            case "up": {
                return "   Up:";
            }
            case "north": {
                return "North:";
            }
            case "south": {
                return "South:";
            }
            case "west": {
                return " West:";
            }
            case "east": {
                return " East:";
            }
        }
        return "-";
    }

    private String getFuelString(int fuelLevel) {
        if (fuelLevel == -1) {
            return "-";
        }
        return String.valueOf(fuelLevel);
    }

    private int alignString(String string, int xPos) {
        if (Objects.equals(string, "   Up:")) {
            return xPos + 4;
        }
        if (Objects.equals(string, " West:") || Objects.equals(string, " East:")) {
            return xPos + 2;
        }
        return xPos;
    }

    public Rect2i getArea() {
        return this.area;
    }

    public static class TurtleData {
        private static final int white = FastColor.ARGB32.m_13660_((int)255, (int)255, (int)255, (int)255);

        public static String getAdjacentTurtleName(TurtleChargingStationBlockEntity station, Direction direction) {
            BlockEntity be = station.m_58904_().m_7702_(station.m_58899_().m_121945_(direction));
            if (be == null) {
                return "-";
            }
            if (be.m_58900_().m_60734_() == ModRegistry.Blocks.TURTLE_NORMAL.get() || be.m_58900_().m_60734_() == ModRegistry.Blocks.TURTLE_ADVANCED.get()) {
                TurtleBlockEntity turtle = (TurtleBlockEntity)be;
                if (turtle.m_8077_()) {
                    return turtle.getLabel();
                }
                return String.valueOf(turtle.getComputerID());
            }
            return "-";
        }

        public static int getAdjacentTurtleColor(TurtleChargingStationBlockEntity station, Direction direction) {
            BlockEntity be = station.m_58904_().m_7702_(station.m_58899_().m_121945_(direction));
            if (be == null) {
                return white;
            }
            if (be.m_58900_().m_60734_() == ModRegistry.Blocks.TURTLE_NORMAL.get() || be.m_58900_().m_60734_() == ModRegistry.Blocks.TURTLE_ADVANCED.get()) {
                TurtleBlockEntity turtle = (TurtleBlockEntity)be;
                if (turtle.getColour() == -1) {
                    return white;
                }
                return turtle.getColour();
            }
            return white;
        }

        public static int getAdjacentTurtleFuel(TurtleChargingStationBlockEntity station, Direction direction) {
            BlockEntity be = station.m_58904_().m_7702_(station.m_58899_().m_121945_(direction));
            if (be == null) {
                return -1;
            }
            if (be.m_58900_().m_60734_() == ModRegistry.Blocks.TURTLE_NORMAL.get() || be.m_58900_().m_60734_() == ModRegistry.Blocks.TURTLE_ADVANCED.get()) {
                TurtleBlockEntity turtle = (TurtleBlockEntity)be;
                return turtle.getAccess().getFuelLevel();
            }
            return -1;
        }
    }
}

