/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.block_entity.FunctionalFlowerBlockEntity;
import vazkii.botania.api.block_entity.SpecialFlowerBlockEntity;
import vazkii.botania.common.block.decor.FloatingFlowerBlock;

public class FloatingSpecialFlowerBlock
extends FloatingFlowerBlock {
    private final Supplier<BlockEntityType<? extends SpecialFlowerBlockEntity>> blockEntityType;

    public FloatingSpecialFlowerBlock(BlockBehaviour.Properties props, Supplier<BlockEntityType<? extends SpecialFlowerBlockEntity>> blockEntityType) {
        super(DyeColor.WHITE, props);
        this.blockEntityType = blockEntityType;
    }

    @Override
    public void m_214162_(BlockState state, Level world, BlockPos pos, RandomSource rand) {
        FloatingSpecialFlowerBlock.redstoneParticlesIfPowered(state, world, pos, rand);
    }

    public static void redstoneParticlesIfPowered(BlockState state, Level world, BlockPos pos, RandomSource rand) {
        BlockEntity te = world.m_7702_(pos);
        if (te instanceof FunctionalFlowerBlockEntity) {
            VoxelShape shape;
            FunctionalFlowerBlockEntity flower = (FunctionalFlowerBlockEntity)te;
            if (rand.m_188499_() && flower.acceptsRedstone() && flower.redstoneSignal > 0 && !(shape = state.m_60808_((BlockGetter)world, pos)).m_83281_()) {
                AABB localBox = shape.m_83215_();
                double x = (double)pos.m_123341_() + localBox.f_82288_ + rand.m_188500_() * (localBox.f_82291_ - localBox.f_82288_);
                double y = (double)pos.m_123342_() + localBox.f_82289_ + rand.m_188500_() * (localBox.f_82292_ - localBox.f_82289_);
                double z = (double)pos.m_123343_() + localBox.f_82290_ + rand.m_188500_() * (localBox.f_82293_ - localBox.f_82290_);
                world.m_7106_((ParticleOptions)DustParticleOptions.f_123656_, x, y, z, 0.0, 0.0, 0.0);
            }
        }
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack stack) {
        ((SpecialFlowerBlockEntity)world.m_7702_(pos)).setPlacedBy(world, pos, state, entity, stack);
    }

    @Override
    @NotNull
    public BlockEntity m_142194_(@NotNull BlockPos pos, @NotNull BlockState state) {
        SpecialFlowerBlockEntity te = (SpecialFlowerBlockEntity)this.blockEntityType.get().m_155264_(pos, state);
        te.setFloating(true);
        return te;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState blockState, BlockEntityType<T> type) {
        return FloatingSpecialFlowerBlock.createTickerHelper(type, this.blockEntityType.get(), SpecialFlowerBlockEntity::commonTick);
    }

    public boolean m_7278_(BlockState bs) {
        return true;
    }

    public int m_6782_(BlockState bs, Level level, BlockPos pos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof SpecialFlowerBlockEntity) {
            SpecialFlowerBlockEntity flower = (SpecialFlowerBlockEntity)blockEntity;
            return flower.getComparatorSignal();
        }
        return 0;
    }
}

