/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.block_entity;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MobBucketItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.block.PetalApothecary;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.recipe.CustomApothecaryColor;
import vazkii.botania.api.recipe.PetalApothecaryRecipe;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.client.gui.HUDHandler;
import vazkii.botania.common.block.PetalApothecaryBlock;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntities;
import vazkii.botania.common.block.block_entity.SimpleInventoryBlockEntity;
import vazkii.botania.common.crafting.BotaniaRecipeTypes;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.helper.EntityHelper;
import vazkii.botania.common.helper.InventoryHelper;
import vazkii.botania.xplat.XplatAbstractions;

public class PetalApothecaryBlockEntity
extends SimpleInventoryBlockEntity
implements PetalApothecary {
    private static final int SET_KEEP_TICKS_EVENT = 0;
    private static final int CRAFT_EFFECT_EVENT = 1;
    private List<ItemStack> lastRecipe = null;
    private Ingredient lastReagent = Ingredient.f_43901_;
    private int recipeKeepTicks = 0;

    public PetalApothecaryBlockEntity(BlockPos pos, BlockState state) {
        super(BotaniaBlockEntities.ALTAR, pos, state);
    }

    public boolean collideEntityItem(ItemEntity item) {
        PetalApothecaryRecipe recipe;
        ItemStack stack = item.m_32055_();
        if (this.f_58857_.f_46443_ || stack.m_41619_() || !item.m_6084_()) {
            return false;
        }
        if (this.getFluid() == PetalApothecary.State.EMPTY) {
            MobBucketItem bucketItem;
            Item item2 = stack.m_41720_();
            if (item2 instanceof MobBucketItem && XplatAbstractions.INSTANCE.getBucketFluid((BucketItem)(bucketItem = (MobBucketItem)item2)) == Fluids.f_76193_) {
                this.setFluid(PetalApothecary.State.WATER);
                bucketItem.m_142131_(null, this.f_58857_, stack, this.m_58899_().m_7494_());
                item.m_32045_(new ItemStack((ItemLike)Items.f_42446_));
                return true;
            }
            if (XplatAbstractions.INSTANCE.extractFluidFromItemEntity(item, (Fluid)Fluids.f_76193_)) {
                this.setFluid(PetalApothecary.State.WATER);
                return true;
            }
            if (XplatAbstractions.INSTANCE.extractFluidFromItemEntity(item, (Fluid)Fluids.f_76195_)) {
                this.setFluid(PetalApothecary.State.LAVA);
                return true;
            }
            return false;
        }
        if (this.getFluid() == PetalApothecary.State.LAVA) {
            item.m_20254_(100);
            return true;
        }
        Optional maybeRecipe = this.f_58857_.m_7465_().m_44015_(BotaniaRecipeTypes.PETAL_TYPE, this.getItemHandler(), this.f_58857_);
        if (maybeRecipe.isPresent() && (recipe = (PetalApothecaryRecipe)maybeRecipe.get()).getReagent().test(item.m_32055_())) {
            this.saveLastRecipe(recipe.getReagent());
            ItemStack output = recipe.m_5874_(this.getItemHandler(), this.m_58904_().m_9598_());
            for (int i = 0; i < this.inventorySize(); ++i) {
                this.getItemHandler().m_6836_(i, ItemStack.f_41583_);
            }
            EntityHelper.shrinkItem(item);
            ItemEntity outputItem = new ItemEntity(this.f_58857_, (double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 1.5, (double)this.f_58858_.m_123343_() + 0.5, output);
            XplatAbstractions.INSTANCE.itemFlagsComponent((ItemEntity)outputItem).apothecarySpawned = true;
            this.f_58857_.m_7967_((Entity)outputItem);
            this.setFluid(PetalApothecary.State.EMPTY, false);
            this.f_58857_.m_142346_(null, GameEvent.f_223702_, this.m_58899_());
            this.f_58857_.m_7696_(this.m_58899_(), this.m_58900_().m_60734_(), 1, 0);
            return true;
        }
        if (!XplatAbstractions.INSTANCE.isFluidContainer(item) && !XplatAbstractions.INSTANCE.itemFlagsComponent((ItemEntity)item).apothecarySpawned) {
            if (!this.getItemHandler().m_8020_(this.inventorySize() - 1).m_41619_()) {
                return false;
            }
            if (this.lastReagent.test(item.m_32055_())) {
                return false;
            }
            for (int i = 0; i < this.inventorySize(); ++i) {
                if (!this.getItemHandler().m_8020_(i).m_41619_()) continue;
                this.getItemHandler().m_6836_(i, stack.m_41620_(1));
                EntityHelper.syncItem(item);
                this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_11917_, SoundSource.BLOCKS, 0.1f, 10.0f);
                this.f_58857_.m_142346_(null, GameEvent.f_157792_, this.m_58899_());
                this.clearLastRecipe();
                return true;
            }
        }
        return false;
    }

    @Nullable
    private CustomApothecaryColor getFlowerComponent(ItemStack stack) {
        CustomApothecaryColor c = null;
        Item item = stack.m_41720_();
        if (item instanceof CustomApothecaryColor) {
            CustomApothecaryColor color;
            c = color = (CustomApothecaryColor)item;
        }
        return c;
    }

    public void saveLastRecipe(Ingredient reagent) {
        ItemStack stack;
        this.lastRecipe = new ArrayList<ItemStack>();
        for (int i = 0; i < this.inventorySize() && !(stack = this.getItemHandler().m_8020_(i)).m_41619_(); ++i) {
            this.lastRecipe.add(stack.m_41777_());
        }
        this.lastReagent = reagent;
        this.recipeKeepTicks = 400;
        this.f_58857_.m_7696_(this.m_58899_(), this.m_58900_().m_60734_(), 0, 400);
    }

    public void clearLastRecipe() {
        this.lastRecipe = null;
        this.lastReagent = Ingredient.f_43901_;
    }

    public InteractionResult trySetLastRecipe(Player player) {
        if (player.m_9236_().m_5776_()) {
            return InteractionResult.m_19078_((boolean)true);
        }
        boolean success = InventoryHelper.tryToSetLastRecipe(player, this.getItemHandler(), this.lastRecipe, SoundEvents.f_11917_);
        if (success) {
            this.f_58857_.m_142346_(null, GameEvent.f_157792_, this.m_58899_());
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
        }
        return success ? InteractionResult.m_19078_((boolean)false) : InteractionResult.PASS;
    }

    public boolean isEmpty() {
        for (int i = 0; i < this.inventorySize(); ++i) {
            if (this.getItemHandler().m_8020_(i).m_41619_()) continue;
            return false;
        }
        return true;
    }

    private void tickRecipeKeep() {
        if (this.recipeKeepTicks > 0) {
            --this.recipeKeepTicks;
        } else {
            this.clearLastRecipe();
        }
    }

    public static void serverTick(Level level, BlockPos worldPosition, BlockState state, PetalApothecaryBlockEntity self) {
        List items = level.m_45976_(ItemEntity.class, new AABB(worldPosition.m_7494_()));
        boolean didChange = false;
        for (ItemEntity item : items) {
            didChange = self.collideEntityItem(item) || didChange;
        }
        if (didChange) {
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers(self);
        }
        self.tickRecipeKeep();
    }

    public static void clientTick(Level level, BlockPos worldPosition, BlockState state, PetalApothecaryBlockEntity self) {
        ItemStack stackAt;
        for (int i = 0; i < self.inventorySize() && !(stackAt = self.getItemHandler().m_8020_(i)).m_41619_(); ++i) {
            if (!(Math.random() >= 0.97)) continue;
            CustomApothecaryColor comp = self.getFlowerComponent(stackAt);
            int color = comp == null ? 0x888888 : comp.getParticleColor(stackAt);
            float red = (float)(color >> 16 & 0xFF) / 255.0f;
            float green = (float)(color >> 8 & 0xFF) / 255.0f;
            float blue = (float)(color & 0xFF) / 255.0f;
            if (Math.random() >= 0.75) {
                level.m_5594_(null, worldPosition, SoundEvents.f_11917_, SoundSource.BLOCKS, 0.1f, 10.0f);
            }
            SparkleParticleData data = SparkleParticleData.sparkle((float)Math.random(), red, green, blue, 10);
            level.m_7106_((ParticleOptions)data, (double)worldPosition.m_123341_() + 0.5 + Math.random() * 0.4 - 0.2, (double)worldPosition.m_123342_() + 1.2, (double)worldPosition.m_123343_() + 0.5 + Math.random() * 0.4 - 0.2, 0.0, 0.0, 0.0);
        }
        if (self.getFluid() == PetalApothecary.State.LAVA) {
            level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)worldPosition.m_123341_() + 0.5 + Math.random() * 0.4 - 0.2, (double)(worldPosition.m_123342_() + 1), (double)worldPosition.m_123343_() + 0.5 + Math.random() * 0.4 - 0.2, 0.0, 0.05, 0.0);
            if (Math.random() > 0.9) {
                level.m_7106_((ParticleOptions)ParticleTypes.f_123756_, (double)worldPosition.m_123341_() + 0.5 + Math.random() * 0.4 - 0.2, (double)(worldPosition.m_123342_() + 1), (double)worldPosition.m_123343_() + 0.5 + Math.random() * 0.4 - 0.2, 0.0, 0.01, 0.0);
            }
        }
        self.tickRecipeKeep();
    }

    public boolean m_7531_(int id, int param) {
        switch (id) {
            case 0: {
                this.recipeKeepTicks = param;
                return true;
            }
            case 1: {
                if (this.f_58857_.f_46443_) {
                    for (int i = 0; i < 25; ++i) {
                        float red = (float)Math.random();
                        float green = (float)Math.random();
                        float blue = (float)Math.random();
                        SparkleParticleData data = SparkleParticleData.sparkle((float)Math.random(), red, green, blue, 10);
                        this.f_58857_.m_7106_((ParticleOptions)data, (double)this.f_58858_.m_123341_() + 0.5 + Math.random() * 0.4 - 0.2, (double)(this.f_58858_.m_123342_() + 1), (double)this.f_58858_.m_123343_() + 0.5 + Math.random() * 0.4 - 0.2, 0.0, 0.0, 0.0);
                    }
                    this.f_58857_.m_7785_((double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_(), BotaniaSounds.altarCraft, SoundSource.BLOCKS, 1.0f, 1.0f, false);
                }
                return true;
            }
        }
        return super.m_7531_(id, param);
    }

    @Override
    protected SimpleContainer createItemHandler() {
        return new SimpleContainer(16){

            public int m_6893_() {
                return 1;
            }
        };
    }

    @Override
    public void setFluid(PetalApothecary.State fluid) {
        this.setFluid(fluid, true);
    }

    public void setFluid(PetalApothecary.State fluid, boolean withVibration) {
        if (withVibration) {
            this.f_58857_.m_142346_(null, fluid == PetalApothecary.State.EMPTY ? GameEvent.f_157816_ : GameEvent.f_157769_, this.m_58899_());
        }
        this.f_58857_.m_46597_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_(PetalApothecaryBlock.FLUID, (Comparable)((Object)fluid)));
    }

    @Override
    public PetalApothecary.State getFluid() {
        return (PetalApothecary.State)((Object)this.m_58900_().m_61143_(PetalApothecaryBlock.FLUID));
    }

    public boolean canAddLastRecipe() {
        return this.isEmpty() && this.getFluid() == PetalApothecary.State.WATER;
    }

    public static class Hud {
        public static void render(PetalApothecaryBlockEntity altar, GuiGraphics gui, Minecraft mc) {
            int xc = mc.m_91268_().m_85445_() / 2;
            int yc = mc.m_91268_().m_85446_() / 2;
            float angle = -90.0f;
            int radius = 24;
            int amt = 0;
            for (int i = 0; i < altar.inventorySize() && !altar.getItemHandler().m_8020_(i).m_41619_(); ++i) {
                ++amt;
            }
            if (amt > 0) {
                float anglePer = 360.0f / (float)amt;
                Optional maybeRecipe = altar.f_58857_.m_7465_().m_44015_(BotaniaRecipeTypes.PETAL_TYPE, altar.getItemHandler(), altar.f_58857_);
                maybeRecipe.ifPresent(recipe -> {
                    ItemStack reagent;
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    RenderHelper.drawTexturedModalRect(gui, HUDHandler.manaBar, xc + radius + 9, yc - 8, 0, 8, 22, 15);
                    ItemStack stack = recipe.m_5874_(altar.getItemHandler(), altar.m_58904_().m_9598_());
                    gui.m_280203_(stack, xc + radius + 32, yc - 8);
                    ItemStack[] reagents = recipe.getReagent().m_43908_();
                    if (reagents.length == 0) {
                        reagent = new ItemStack((ItemLike)Items.f_42127_);
                    } else {
                        int idx = (int)(altar.f_58857_.m_46467_() / 20L % (long)reagents.length);
                        reagent = reagents[idx];
                    }
                    gui.m_280203_(reagent, xc + radius + 16, yc + 6);
                    gui.m_280056_(mc.f_91062_, "+", xc + radius + 14, yc + 10, 0xFFFFFF, false);
                });
                for (int i = 0; i < amt; ++i) {
                    double xPos = (double)xc + Math.cos((double)angle * Math.PI / 180.0) * (double)radius - 8.0;
                    double yPos = (double)yc + Math.sin((double)angle * Math.PI / 180.0) * (double)radius - 8.0;
                    PoseStack pose = RenderSystem.getModelViewStack();
                    pose.m_85836_();
                    pose.m_85837_(xPos, yPos, 0.0);
                    RenderSystem.applyModelViewMatrix();
                    gui.m_280203_(altar.getItemHandler().m_8020_(i), 0, 0);
                    pose.m_85849_();
                    RenderSystem.applyModelViewMatrix();
                    angle += anglePer;
                }
            }
            if (altar.recipeKeepTicks > 0 && altar.canAddLastRecipe()) {
                String s = I18n.m_118938_((String)"botaniamisc.altarRefill0", (Object[])new Object[0]);
                gui.m_280056_(mc.f_91062_, s, xc - mc.f_91062_.m_92895_(s) / 2, yc + 10, 0xFFFFFF, false);
                s = I18n.m_118938_((String)"botaniamisc.altarRefill1", (Object[])new Object[0]);
                gui.m_280056_(mc.f_91062_, s, xc - mc.f_91062_.m_92895_(s) / 2, yc + 20, 0xFFFFFF, false);
            }
        }
    }
}

