/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.block_entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.block.Wandable;
import vazkii.botania.common.block.PlatformBlock;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntities;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntity;

public class PlatformBlockEntity
extends BotaniaBlockEntity
implements Wandable {
    private static final String TAG_CAMO = "camo";
    @Nullable
    private BlockState camoState;

    public PlatformBlockEntity(BlockPos pos, BlockState state) {
        super(BotaniaBlockEntities.PLATFORM, pos, state);
    }

    @Override
    public boolean onUsedByWand(@Nullable Player player, ItemStack stack, Direction side) {
        if (player != null) {
            PlatformBlock.Variant variant = this.getVariant();
            if (variant.indestructible && !player.m_7500_()) {
                return false;
            }
            if (this.getCamoState() == null || player.m_6144_()) {
                this.swapSelfAndPass(this, true, variant);
            } else {
                this.swapSurroudings(this, false, variant);
            }
            return true;
        }
        return false;
    }

    @Nullable
    public BlockState getCamoState() {
        return this.camoState;
    }

    public void setCamoState(@Nullable BlockState state) {
        this.camoState = state;
        if (this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
            if (!this.f_58857_.f_46443_) {
                this.f_58857_.m_6289_(this.f_58858_, this.m_58900_().m_60734_());
                this.m_6596_();
            }
        }
    }

    private PlatformBlock.Variant getVariant() {
        return ((PlatformBlock)this.m_58900_().m_60734_()).getVariant();
    }

    private void swapSelfAndPass(PlatformBlockEntity tile, boolean empty, PlatformBlock.Variant variant) {
        this.swap(tile, empty);
        this.swapSurroudings(tile, empty, variant);
    }

    private void swapSurroudings(PlatformBlockEntity tile, boolean empty, PlatformBlock.Variant variant) {
        for (Direction dir : Direction.values()) {
            BlockPos pos = tile.m_58899_().m_121945_(dir);
            BlockEntity tileAt = this.f_58857_.m_7702_(pos);
            if (!(tileAt instanceof PlatformBlockEntity)) continue;
            PlatformBlockEntity platform = (PlatformBlockEntity)tileAt;
            if (tile.getVariant() != platform.getVariant() || empty != (platform.getCamoState() != null)) continue;
            this.swapSelfAndPass(platform, empty, variant);
        }
    }

    private void swap(PlatformBlockEntity tile, boolean empty) {
        tile.setCamoState(empty ? null : this.getCamoState());
    }

    @Override
    public void writePacketNBT(CompoundTag cmp) {
        if (this.getCamoState() != null) {
            cmp.m_128365_(TAG_CAMO, (Tag)NbtUtils.m_129202_((BlockState)this.getCamoState()));
        }
    }

    @Override
    public void readPacketNBT(CompoundTag cmp) {
        Object holderGetter = this.f_58857_ != null ? this.f_58857_.m_246945_(Registries.f_256747_) : BuiltInRegistries.f_256975_.m_255303_();
        BlockState state = NbtUtils.m_247651_((HolderGetter)holderGetter, (CompoundTag)cmp.m_128469_(TAG_CAMO));
        if (state.m_60795_()) {
            state = null;
        }
        this.setCamoState(state);
        if (this.f_58857_ != null && this.f_58857_.f_46443_) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 0);
        }
    }

    public Object getRenderData() {
        return new PlatformData(this);
    }

    public record PlatformData(BlockPos pos, @Nullable BlockState state) {
        public PlatformData(PlatformBlockEntity tile) {
            this(tile.m_58899_().m_7949_(), tile.camoState);
        }
    }
}

