/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.helper;

import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.TntBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.piston.PistonMovingBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import vazkii.botania.xplat.XplatAbstractions;

public class EthicalTntHelper {
    private static final ThreadLocal<EthicalTntHelper> tracker = ThreadLocal.withInitial(EthicalTntHelper::new);
    private final AtomicInteger trackTntEntities = new AtomicInteger();
    private final WeakHashMap<Level, IntOpenHashSet> trackedTntEntities = new WeakHashMap();

    public static void startTrackingTntEntities() {
        tracker.get().startTracking();
    }

    public static void addTrackedTntEntity(PrimedTnt entity) {
        tracker.get().addTrackedEntity(entity);
    }

    public static void endTrackingTntEntitiesAndCheck() {
        tracker.get().endTracking();
    }

    private void startTracking() {
        this.trackTntEntities.incrementAndGet();
    }

    private void addTrackedEntity(PrimedTnt entity) {
        if (this.trackTntEntities.get() > 0) {
            this.trackedTntEntities.computeIfAbsent(entity.m_9236_(), lvl -> new IntOpenHashSet()).add(entity.m_19879_());
        }
    }

    private void endTracking() {
        if (this.trackTntEntities.decrementAndGet() == 0) {
            for (Map.Entry<Level, IntOpenHashSet> entry : this.trackedTntEntities.entrySet()) {
                Level level = entry.getKey();
                IntOpenHashSet trackedEntities = entry.getValue();
                if (trackedEntities == null) continue;
                for (Integer tntId : trackedEntities) {
                    Entity entity = level.m_6815_(tntId.intValue());
                    if (!(entity instanceof PrimedTnt)) continue;
                    PrimedTnt tnt = (PrimedTnt)entity;
                    EthicalTntHelper.checkUnethical(tnt);
                }
                trackedEntities.clear();
            }
        }
    }

    private static void checkUnethical(PrimedTnt entity) {
        BlockPos center = entity.m_20183_();
        if (!entity.m_9236_().m_46749_(center)) {
            return;
        }
        BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos();
        for (Direction dir : Direction.values()) {
            PistonMovingBlockEntity movingBlockEntity;
            BlockEntity blockEntity;
            BlockState blockState;
            blockPos.m_122159_((Vec3i)center, dir);
            if (!entity.m_9236_().m_46749_((BlockPos)blockPos) || !(blockState = entity.m_9236_().m_8055_((BlockPos)blockPos)).m_60713_(Blocks.f_50110_) || !((blockEntity = entity.m_9236_().m_7702_((BlockPos)blockPos)) instanceof PistonMovingBlockEntity) || (movingBlockEntity = (PistonMovingBlockEntity)blockEntity).m_60399_() != dir || !(movingBlockEntity.m_60400_().m_60734_() instanceof TntBlock)) continue;
            XplatAbstractions.INSTANCE.ethicalComponent(entity).markUnethical();
            break;
        }
    }
}

