/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.jeicompat;

import com.google.common.base.Predicates;
import dev.architectury.fluid.FluidStack;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.category.visibility.CategoryVisibilityPredicate;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.client.registry.display.reason.DisplayAdditionReason;
import me.shedaniel.rei.api.client.registry.display.visibility.DisplayVisibilityPredicate;
import me.shedaniel.rei.api.client.registry.entry.EntryRegistry;
import me.shedaniel.rei.api.client.registry.screen.ScreenRegistry;
import me.shedaniel.rei.api.client.registry.transfer.TransferHandlerRegistry;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.display.DisplaySerializer;
import me.shedaniel.rei.api.common.display.DisplaySerializerRegistry;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.comparison.ComparisonContext;
import me.shedaniel.rei.api.common.entry.comparison.FluidComparatorRegistry;
import me.shedaniel.rei.api.common.entry.comparison.ItemComparatorRegistry;
import me.shedaniel.rei.api.common.entry.type.EntryDefinition;
import me.shedaniel.rei.api.common.entry.type.EntryType;
import me.shedaniel.rei.api.common.entry.type.EntryTypeRegistry;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import me.shedaniel.rei.api.common.plugins.PluginManager;
import me.shedaniel.rei.api.common.plugins.REIPluginProvider;
import me.shedaniel.rei.api.common.registry.ReloadStage;
import me.shedaniel.rei.api.common.registry.Reloadable;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import me.shedaniel.rei.impl.common.InternalLogger;
import me.shedaniel.rei.jeicompat.CompatPlatform;
import me.shedaniel.rei.jeicompat.imitator.JEIInternalsClickedIngredient;
import me.shedaniel.rei.jeicompat.unwrap.JEIUnwrappedCategory;
import me.shedaniel.rei.jeicompat.wrap.JEIAdvancedRegistration;
import me.shedaniel.rei.jeicompat.wrap.JEIGuiHandlerRegistration;
import me.shedaniel.rei.jeicompat.wrap.JEIJeiHelpers;
import me.shedaniel.rei.jeicompat.wrap.JEIJeiRuntime;
import me.shedaniel.rei.jeicompat.wrap.JEIModIngredientRegistration;
import me.shedaniel.rei.jeicompat.wrap.JEIRecipeCatalystRegistration;
import me.shedaniel.rei.jeicompat.wrap.JEIRecipeManager;
import me.shedaniel.rei.jeicompat.wrap.JEIRecipeRegistration;
import me.shedaniel.rei.jeicompat.wrap.JEIRecipeTransferRegistration;
import me.shedaniel.rei.jeicompat.wrap.JEISubtypeRegistration;
import me.shedaniel.rei.jeicompat.wrap.JEITypedIngredient;
import me.shedaniel.rei.jeicompat.wrap.JEIVanillaCategoryExtensionRegistration;
import me.shedaniel.rei.jeicompat.wrap.JEIWrappedCategory;
import me.shedaniel.rei.jeicompat.wrap.JEIWrappedDisplay;
import me.shedaniel.rei.plugin.common.BuiltinPlugin;
import me.shedaniel.rei.plugin.common.displays.crafting.DefaultCraftingDisplay;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.IIngredientTypeWithSubtypes;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.advanced.IRecipeManagerPlugin;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.category.extensions.IRecipeCategoryExtension;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.runtime.IClickableIngredient;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.material.Fluid;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.logging.log4j.util.TriConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JEIPluginDetector {
    private static final Renderer EMPTY_RENDERER = new Renderer(){

        public void render(GuiGraphics graphics, Rectangle bounds, int mouseX, int mouseY, float delta) {
        }
    };
    private static final Map<IIngredientType<?>, EntryType<?>> TYPE_MAP = new HashMap();
    public static final Map<Class<?>, IIngredientType<?>> INGREDIENT_TYPE_MAP = new HashMap();
    public static final Map<ResourceLocation, CategoryIdentifier<?>> CATEGORY_ID_MAP = new HashMap();
    public static final Map<ResourceLocation, RecipeType<?>> RECIPE_TYPE_MAP = new HashMap();

    public static void detect(BiConsumer<Class<?>, TriConsumer<List<String>, Supplier<?>, Class<?>>> annotationScanner, TriConsumer<List<String>, Class<?>, Supplier<REIPluginProvider>> pluginAdder) {
        annotationScanner.accept(JeiPlugin.class, (modIds, plugin, clazz) -> pluginAdder.accept(modIds, clazz, () -> JEIPluginDetector.lambda$detect$1(modIds, (Supplier)plugin, clazz)));
    }

    public static RuntimeException TODO() {
        return new UnsupportedOperationException("This operation has not been implemented yet!");
    }

    public static RuntimeException WILL_NOT_BE_IMPLEMENTED() {
        return new UnsupportedOperationException("This operation will not be implemented in REI's JEI Compatibility Layer!");
    }

    public static Renderer unwrapRenderer(final IDrawable drawable) {
        if (drawable == null) {
            return JEIPluginDetector.emptyRenderer();
        }
        return new Renderer(){

            public void render(GuiGraphics graphics, Rectangle bounds, int mouseX, int mouseY, float delta) {
                drawable.draw(graphics, bounds.x, bounds.y);
            }
        };
    }

    public static Renderer emptyRenderer() {
        return EMPTY_RENDERER;
    }

    public static IRecipeManagerPlugin wrapDefaultRecipeManagerPlugin() {
        return new IRecipeManagerPlugin(){

            @Override
            @NotNull
            public <V> List<RecipeType<?>> getRecipeTypes(@NotNull IFocus<V> focus) {
                throw JEIPluginDetector.TODO();
            }

            @Override
            @NotNull
            public <T, V> List<T> getRecipes(@NotNull IRecipeCategory<T> recipeCategory, @NotNull IFocus<V> focus) {
                throw JEIPluginDetector.TODO();
            }

            @Override
            @NotNull
            public <T> List<T> getRecipes(@NotNull IRecipeCategory<T> recipeCategory) {
                CategoryIdentifier categoryId = JEIPluginDetector.categoryId(recipeCategory.getRecipeType());
                return JEIPluginDetector.wrapRecipes(categoryId, false);
            }
        };
    }

    public static <A extends Display, T> List<T> wrapRecipes(CategoryIdentifier<A> id, boolean checkVisible) {
        return JEIPluginDetector.wrapRecipes(CategoryRegistry.getInstance().get(id).getCategory(), DisplayRegistry.getInstance().get(id), checkVisible);
    }

    public static <A extends Display, T> List<T> wrapRecipes(DisplayCategory<?> category, List<A> displays, boolean checkVisible) {
        boolean isWrappedCategory = category instanceof JEIWrappedCategory;
        if (checkVisible && CategoryRegistry.getInstance().isCategoryInvisible(category)) {
            return new ArrayList();
        }
        if (isWrappedCategory) {
            return CollectionUtils.filterAndMap(displays, display -> !checkVisible || DisplayRegistry.getInstance().isDisplayVisible(display), display -> ((JEIWrappedDisplay)display).getBackingRecipe());
        }
        if (checkVisible) {
            return CollectionUtils.filterAndMap(displays, display -> DisplayRegistry.getInstance().isDisplayVisible(display), display -> DisplayRegistry.getInstance().getDisplayOrigin(display));
        }
        return CollectionUtils.map(displays, display -> DisplayRegistry.getInstance().getDisplayOrigin(display));
    }

    @Nullable
    public static <A extends Display> Object jeiValue(A display) {
        boolean isWrappedCategory = display instanceof JEIWrappedDisplay;
        if (isWrappedCategory) {
            return ((JEIWrappedDisplay)display).getBackingRecipe();
        }
        Object origin = DisplayRegistry.getInstance().getDisplayOrigin(display);
        if (origin instanceof DefaultCraftingDisplay) {
            origin = ((DefaultCraftingDisplay)origin).getOptionalRecipe().orElse(origin);
        }
        return origin;
    }

    public static Display asDisplay(Object object) {
        if (object instanceof Display) {
            return (Display)object;
        }
        return (Display)DisplayRegistry.getInstance().tryFillDisplay(object).stream().findAny().orElseThrow(() -> new IllegalArgumentException("Could not wrap recipe as display! " + object.getClass().getName()));
    }

    public static <T> Collection<Display> createDisplayFrom(T object) {
        return DisplayRegistry.getInstance().tryFillDisplay(object);
    }

    public static IRecipeCategory<?> wrapCategory(DisplayCategory<?> category) {
        if (category instanceof JEIWrappedCategory) {
            return ((JEIWrappedCategory)category).getBackingCategory();
        }
        return new JEIUnwrappedCategory(category);
    }

    public static <T> T jeiValue(EntryStack<T> stack) {
        Object value = stack.getValue();
        if (value instanceof FluidStack) {
            return (T)CompatPlatform.get().toPlatformFluidStack((FluidStack)value);
        }
        return (T)value;
    }

    public static <T> ITypedIngredient<T> typedJeiValue(EntryStack<T> stack) {
        if (stack == null) {
            return null;
        }
        Object value = stack.getValue();
        if (value instanceof FluidStack) {
            return new JEITypedIngredient<Object>(CompatPlatform.get().getPlatformFluidHelper().getFluidIngredientType(), CompatPlatform.get().toPlatformFluidStack((FluidStack)value));
        }
        return new JEITypedIngredient<Object>(JEIPluginDetector.jeiType(stack.getDefinition()), value);
    }

    public static <T> Optional<ITypedIngredient<T>> typedJeiValueOp(EntryStack<T> stack) {
        if (stack == null || stack.isEmpty()) {
            return Optional.empty();
        }
        return Optional.ofNullable(JEIPluginDetector.typedJeiValue(stack));
    }

    public static <T> Optional<ITypedIngredient<?>> typedJeiValueOpWild(EntryStack<T> stack) {
        return JEIPluginDetector.typedJeiValueOp(stack);
    }

    public static <T> T jeiValueOrNull(EntryStack<T> stack) {
        if (stack.isEmpty()) {
            return null;
        }
        return JEIPluginDetector.jeiValue(stack);
    }

    public static UidContext wrapContext(ComparisonContext context) {
        return context == ComparisonContext.FUZZY ? UidContext.Recipe : UidContext.Ingredient;
    }

    public static ComparisonContext unwrapContext(UidContext context) {
        return context == UidContext.Recipe ? ComparisonContext.FUZZY : ComparisonContext.EXACT;
    }

    public static <B, T> IIngredientTypeWithSubtypes<B, T> makeJeiTypeWithSubtype(final Class<? extends T> c, final Class<? extends B> bc, final Function<T, B> mapper) {
        return new IIngredientTypeWithSubtypes<B, T>(){

            @Override
            public Class<? extends T> getIngredientClass() {
                return c;
            }

            @Override
            public Class<? extends B> getIngredientBaseClass() {
                return bc;
            }

            @Override
            public B getBase(T ingredient) {
                return mapper.apply(ingredient);
            }
        };
    }

    public static <T> IIngredientType<T> jeiType(EntryDefinition<T> definition) {
        return JEIPluginDetector.jeiType(definition.getValueType());
    }

    public static <T> IIngredientType<T> jeiType(Class<? extends T> c) {
        IIngredientType<?> existingType = INGREDIENT_TYPE_MAP.get(c);
        if (existingType != null) {
            return existingType;
        }
        IIngredientType type = () -> c;
        INGREDIENT_TYPE_MAP.put(c, type);
        return type;
    }

    public static <T extends Display, R> CategoryIdentifier<T> categoryId(RecipeType<R> id) {
        return JEIPluginDetector.categoryId(id.getUid());
    }

    public static <T extends Display, R> RecipeType<R> asRecipeType(CategoryIdentifier<T> id, Class<? extends R> recipeType) {
        return JEIPluginDetector.asRecipeType(id.getIdentifier(), recipeType);
    }

    public static <R> RecipeType<R> asRecipeType(ResourceLocation id, Class<? extends R> recipeType) {
        RecipeType<?> existingType = RECIPE_TYPE_MAP.get(id);
        if (existingType != null) {
            return existingType;
        }
        RecipeType<? extends R> type = new RecipeType<R>(id, recipeType);
        RECIPE_TYPE_MAP.putIfAbsent(id, type);
        return type;
    }

    public static <T extends Display> CategoryIdentifier<T> categoryId(ResourceLocation id) {
        CategoryIdentifier<?> existingId = CATEGORY_ID_MAP.get(id);
        if (existingId != null) {
            return existingId.cast();
        }
        CategoryIdentifier identifier = CategoryIdentifier.of((ResourceLocation)id);
        CATEGORY_ID_MAP.putIfAbsent(id, identifier);
        return identifier;
    }

    public static <T> EntryStack<T> unwrapStack(T stack, IIngredientType<T> type) {
        return JEIPluginDetector.unwrapStack(stack, JEIPluginDetector.unwrapType(type).getDefinition());
    }

    public static <T> EntryStack<T> unwrapStack(T stack, EntryDefinition<T> definition) {
        if (stack == null) {
            return EntryStack.empty().cast();
        }
        if (definition.getType() == VanillaEntryTypes.FLUID) {
            return EntryStack.of(definition, (Object)CompatPlatform.get().fromPlatformFluidStack(stack));
        }
        return EntryStack.of(definition, stack);
    }

    public static <T> EntryIngredient unwrapList(IIngredientType<T> type, List<T> stack) {
        return JEIPluginDetector.unwrapList(JEIPluginDetector.unwrapType(type).getDefinition(), stack);
    }

    public static <T> EntryIngredient unwrapList(EntryDefinition<T> definition, List<T> stack) {
        if (definition.getType() == VanillaEntryTypes.FLUID) {
            return EntryIngredients.of(definition, (Collection)CollectionUtils.filterAndMap(stack, (Predicate)Predicates.notNull(), s -> CompatPlatform.get().fromPlatformFluidStack(s)));
        }
        return EntryIngredients.of(definition, stack);
    }

    public static <T> EntryType<T> unwrapType(IIngredientType<T> t) {
        return TYPE_MAP.computeIfAbsent(t, type -> {
            if (type.getIngredientClass() == CompatPlatform.get().getPlatformFluidStackClass()) {
                return VanillaEntryTypes.FLUID.cast();
            }
            for (EntryDefinition definition : EntryTypeRegistry.getInstance().values()) {
                if (!Objects.equals(definition.getValueType(), type.getIngredientClass())) continue;
                return definition.getType().cast();
            }
            throw new IllegalArgumentException("Unknown JEI Ingredient Type! " + type.getIngredientClass().getName());
        }).cast();
    }

    public static <T> EntryDefinition<T> unwrapDefinition(IIngredientType<T> type) {
        return JEIPluginDetector.unwrapType(type).getDefinition();
    }

    public static EntryStack<?> unwrapStack(Object stack) {
        if (stack instanceof IClickableIngredient) {
            stack = ((IClickableIngredient)((Object)stack)).getTypedIngredient();
        }
        if (stack instanceof ITypedIngredient) {
            return JEIPluginDetector.unwrapStack(stack.getIngredient(), JEIPluginDetector.unwrapDefinition(stack.getType()).cast());
        }
        if (stack instanceof JEIInternalsClickedIngredient) {
            return JEIPluginDetector.unwrapStack(((JEIInternalsClickedIngredient)((Object)stack)).getValue());
        }
        return JEIPluginDetector.unwrapStack(stack, JEIPluginDetector.unwrapDefinition(stack).cast());
    }

    public static EntryType<?> unwrapType(Object stack) {
        if (stack instanceof ItemStack) {
            return VanillaEntryTypes.ITEM;
        }
        if (CompatPlatform.get().getPlatformFluidStackClass().isInstance(stack)) {
            return VanillaEntryTypes.FLUID;
        }
        for (EntryDefinition definition : EntryTypeRegistry.getInstance().values()) {
            if (!definition.getValueType().isInstance(stack)) continue;
            return definition.cast().getType();
        }
        throw new IllegalArgumentException("Failed to find EntryType of " + stack + "!");
    }

    public static EntryDefinition<?> unwrapDefinition(Object stack) {
        return JEIPluginDetector.unwrapType(stack).getDefinition();
    }

    public static IRecipeCategoryRegistration wrapCategoryRegistration(final CategoryRegistry registry, final Consumer<JEIWrappedCategory<?>> added) {
        return new IRecipeCategoryRegistration(){

            @Override
            @NotNull
            public IJeiHelpers getJeiHelpers() {
                return JEIJeiHelpers.INSTANCE;
            }

            @Override
            public void addRecipeCategories(IRecipeCategory<?> ... categories) {
                for (IRecipeCategory<?> category : categories) {
                    JEIWrappedCategory wrappedCategory = new JEIWrappedCategory(category);
                    registry.add(wrappedCategory);
                    added.accept(wrappedCategory);
                }
            }
        };
    }

    private static /* synthetic */ REIPluginProvider lambda$detect$1(List modIds, Supplier plugin, Class clazz) {
        Supplier<JEIPluginWrapper> value = () -> JEIPluginDetector.lambda$detect$0(modIds, (Supplier)plugin);
        InternalLogger.getInstance().info("Detected JEI plugin from [%s]: %s".formatted(String.join((CharSequence)", ", modIds), clazz.getName()));
        return new JEIPluginProvider(modIds, value, JEIPluginProvider.name(clazz));
    }

    private static /* synthetic */ JEIPluginWrapper lambda$detect$0(List modIds, Supplier plugin) {
        return new JEIPluginWrapper(modIds, (IModPlugin)plugin.get());
    }

    static {
        INGREDIENT_TYPE_MAP.put(ItemStack.class, JEIPluginDetector.makeJeiTypeWithSubtype(ItemStack.class, Item.class, ItemStack::m_41720_));
        INGREDIENT_TYPE_MAP.put(CompatPlatform.get().getPlatformFluidStackClass(), JEIPluginDetector.makeJeiTypeWithSubtype(CompatPlatform.get().getPlatformFluidStackClass(), Fluid.class, f -> CompatPlatform.get().getFluid(f)));
        CATEGORY_ID_MAP.put(new ResourceLocation("minecraft", "crafting"), BuiltinPlugin.CRAFTING);
        CATEGORY_ID_MAP.put(new ResourceLocation("minecraft", "stonecutting"), BuiltinPlugin.STONE_CUTTING);
        CATEGORY_ID_MAP.put(new ResourceLocation("minecraft", "furnace"), BuiltinPlugin.SMELTING);
        CATEGORY_ID_MAP.put(new ResourceLocation("minecraft", "smoking"), BuiltinPlugin.SMOKING);
        CATEGORY_ID_MAP.put(new ResourceLocation("minecraft", "blasting"), BuiltinPlugin.BLASTING);
        CATEGORY_ID_MAP.put(new ResourceLocation("minecraft", "campfire"), BuiltinPlugin.CAMPFIRE);
        CATEGORY_ID_MAP.put(new ResourceLocation("minecraft", "brewing"), BuiltinPlugin.BREWING);
        CATEGORY_ID_MAP.put(new ResourceLocation("minecraft", "anvil"), BuiltinPlugin.ANVIL);
        CATEGORY_ID_MAP.put(new ResourceLocation("minecraft", "smithing"), BuiltinPlugin.SMITHING);
        CATEGORY_ID_MAP.put(new ResourceLocation("minecraft", "compostable"), BuiltinPlugin.COMPOSTING);
        CATEGORY_ID_MAP.put(new ResourceLocation("minecraft", "fuel"), BuiltinPlugin.FUEL);
        CATEGORY_ID_MAP.put(new ResourceLocation("minecraft", "information"), BuiltinPlugin.INFO);
    }

    public static class JEIPluginProvider
    implements REIPluginProvider<REIClientPlugin> {
        public final List<String> modIds;
        public final Supplier<JEIPluginWrapper> supplier;
        private final String clazz;
        public JEIPluginWrapper wrapper;
        private String nameSuffix;

        public JEIPluginProvider(List<String> modIds, Supplier<JEIPluginWrapper> supplier, String clazz) {
            this.modIds = modIds;
            this.supplier = supplier;
            this.clazz = clazz;
            this.nameSuffix = " [" + String.join((CharSequence)", ", modIds) + "]";
        }

        public String getPluginProviderName() {
            if (this.modIds.contains("recipestages") && this.wrapper == null) {
                this.wrapper = this.supplier.get();
            }
            if (this.wrapper != null) {
                return this.wrapper.getPluginProviderName() + this.nameSuffix;
            }
            return "JEI Plugin [" + this.clazz + "]" + this.nameSuffix;
        }

        public static String name(Class<?> clazz) {
            String simpleName = clazz.getSimpleName();
            simpleName = simpleName == null ? clazz.getName() : simpleName;
            return simpleName;
        }

        public Collection<REIClientPlugin> provide() {
            if (this.wrapper != null) {
                return Collections.singletonList(this.wrapper);
            }
            this.wrapper = this.supplier.get();
            return Collections.singletonList(this.wrapper);
        }

        public Class<REIClientPlugin> getPluginProviderClass() {
            return REIClientPlugin.class;
        }
    }

    public static class JEIPluginWrapper
    implements REIClientPlugin {
        public final boolean mainThread;
        public final boolean forceRuntime;
        public final IModPlugin backingPlugin;
        public final Map<DisplayCategory<?>, List<Triple<Class<?>, Predicate<Object>, Function<Object, IRecipeCategoryExtension>>>> categories = new HashMap();
        public final List<Runnable> entryRegistry = new ArrayList<Runnable>();
        public final List<Runnable> post = new ArrayList<Runnable>();

        public JEIPluginWrapper(List<String> modIds, IModPlugin backingPlugin) {
            this.backingPlugin = Objects.requireNonNull(backingPlugin, "Missing plugin for " + String.join((CharSequence)", ", modIds));
            this.mainThread = CollectionUtils.anyMatch(Arrays.asList("jeresources", "jepb"), modIds::contains);
            this.forceRuntime = CollectionUtils.anyMatch(Arrays.asList("recipestages"), modIds::contains);
            if (this.forceRuntime) {
                backingPlugin.onRuntimeAvailable(JEIJeiRuntime.INSTANCE);
            }
        }

        public void registerEntryTypes(EntryTypeRegistry registry) {
            this.backingPlugin.registerIngredients(new JEIModIngredientRegistration(this, registry));
        }

        public void registerEntries(EntryRegistry registry) {
            for (Runnable runnable : this.entryRegistry) {
                runnable.run();
            }
            this.entryRegistry.clear();
        }

        public void registerItemComparators(ItemComparatorRegistry registry) {
            this.backingPlugin.registerItemSubtypes(JEISubtypeRegistration.INSTANCE);
        }

        public void registerFluidComparators(FluidComparatorRegistry registry) {
            this.backingPlugin.registerFluidSubtypes(JEISubtypeRegistration.INSTANCE, CompatPlatform.get().getPlatformFluidHelper());
        }

        public void registerCategories(CategoryRegistry registry) {
            this.categories.clear();
            this.backingPlugin.registerCategories(JEIPluginDetector.wrapCategoryRegistration(registry, category -> {
                this.categories.put((DisplayCategory<?>)category, new ArrayList());
                DisplayRegistry.getInstance().registerFiller(category.getRecipeClass(), (o, reason) -> category.handlesRecipe(o) && !reason.has(DisplayAdditionReason.RECIPE_MANAGER), recipe -> new JEIWrappedDisplay<Object>((JEIWrappedCategory<Object>)category, recipe));
                DisplayRegistry.getInstance().registerFiller(JEIWrappedDisplay.class, display -> display.getCategoryIdentifier().getIdentifier().equals((Object)category.getIdentifier()), Function.identity());
                this.post.add(() -> {
                    if (Recipe.class.isAssignableFrom(category.getRecipeClass())) {
                        DisplaySerializerRegistry.getInstance().register(category.getCategoryIdentifier(), new DisplaySerializer<JEIWrappedDisplay<?>>(){
                            final /* synthetic */ JEIWrappedCategory val$category;
                            {
                                this.val$category = jEIWrappedCategory;
                            }

                            public CompoundTag save(CompoundTag tag, JEIWrappedDisplay<?> display) {
                                Recipe recipe = (Recipe)display.getBackingRecipe();
                                FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
                                recipe.m_7707_().m_6178_(buf, recipe);
                                tag.m_128359_("JEISerializer", BuiltInRegistries.f_256769_.m_7981_((Object)recipe.m_7707_()).toString());
                                tag.m_128359_("data", Base64.getEncoder().encodeToString(buf.array()));
                                tag.m_128359_("id", recipe.m_6423_().toString());
                                return tag;
                            }

                            public JEIWrappedDisplay<?> read(CompoundTag tag) {
                                RecipeSerializer serializer = (RecipeSerializer)BuiltInRegistries.f_256769_.m_7745_(new ResourceLocation(tag.m_128461_("JEISerializer")));
                                FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.copiedBuffer((byte[])Base64.getDecoder().decode(tag.m_128461_("data"))));
                                Recipe recipe = serializer.m_8005_(new ResourceLocation(tag.m_128461_("id")), buf);
                                return new JEIWrappedDisplay<Recipe>(this.val$category, recipe);
                            }

                            public boolean isPersistent() {
                                return false;
                            }
                        });
                    } else {
                        DisplaySerializerRegistry.getInstance().registerNotSerializable(category.getCategoryIdentifier());
                    }
                });
            }));
            this.backingPlugin.registerVanillaCategoryExtensions(new JEIVanillaCategoryExtensionRegistration(this));
            if (!registry.getVisibilityPredicates().contains(JEIRecipeManager.INSTANCE.categoryPredicate)) {
                registry.registerVisibilityPredicate((CategoryVisibilityPredicate)JEIRecipeManager.INSTANCE.categoryPredicate);
            }
        }

        public void registerDisplays(DisplayRegistry registry) {
            this.backingPlugin.registerRecipes(new JEIRecipeRegistration(this.post));
            this.backingPlugin.registerAdvanced(JEIAdvancedRegistration.INSTANCE);
            if (!registry.getVisibilityPredicates().contains(JEIRecipeManager.INSTANCE.displayPredicate)) {
                registry.registerVisibilityPredicate((DisplayVisibilityPredicate)JEIRecipeManager.INSTANCE.displayPredicate);
            }
            this.backingPlugin.registerRecipeCatalysts(JEIRecipeCatalystRegistration.INSTANCE);
        }

        public void registerScreens(ScreenRegistry registry) {
            this.backingPlugin.registerGuiHandlers(JEIGuiHandlerRegistration.INSTANCE);
        }

        public void registerTransferHandlers(TransferHandlerRegistry registry) {
            this.backingPlugin.registerRecipeTransferHandlers(new JEIRecipeTransferRegistration(this.post::add));
        }

        public void postStage(PluginManager<REIClientPlugin> manager, ReloadStage stage) {
            if (stage == ReloadStage.END && Objects.equals(manager, PluginManager.getClientInstance())) {
                InternalLogger.getInstance().debug("Running post-register for %s with %d post tasks", new Object[]{this.getPluginProviderName(), this.post.size()});
                for (Map.Entry<DisplayCategory<?>, List<Triple<Class<?>, Predicate<Object>, Function<Object, IRecipeCategoryExtension>>>> entry : this.categories.entrySet()) {
                    DisplayCategory<?> category = entry.getKey();
                    for (Triple<Class<?>, Predicate<Object>, Function<Object, IRecipeCategoryExtension>> triple : entry.getValue()) {
                    }
                }
                if (!this.forceRuntime) {
                    this.backingPlugin.onRuntimeAvailable(JEIJeiRuntime.INSTANCE);
                }
                for (Runnable runnable : this.entryRegistry) {
                    try {
                        runnable.run();
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                }
                for (Runnable runnable : this.post) {
                    try {
                        runnable.run();
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                }
                this.entryRegistry.clear();
                this.post.clear();
            }
        }

        public String getPluginProviderName() {
            Class<?> pluginClass = this.backingPlugin.getClass();
            String simpleName = pluginClass.getSimpleName();
            simpleName = simpleName == null ? pluginClass.getName() : simpleName;
            return "JEI Plugin [" + simpleName + ":" + this.backingPlugin.getPluginUid() + "]";
        }

        public boolean shouldBeForcefullyDoneOnMainThread(Reloadable<?> reloadable) {
            if (!this.mainThread) {
                return false;
            }
            return reloadable instanceof DisplayRegistry;
        }
    }
}

