/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.jeicompat;

import com.google.common.base.Suppliers;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import me.shedaniel.rei.api.common.plugins.REIPlugin;
import me.shedaniel.rei.api.common.plugins.REIPluginProvider;
import me.shedaniel.rei.forge.AnnotationUtils;
import me.shedaniel.rei.forge.REIPluginLoaderClient;
import me.shedaniel.rei.impl.common.InternalLogger;
import me.shedaniel.rei.jeicompat.JEIPluginDetector;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.ModFileScanData;
import org.apache.logging.log4j.util.TriConsumer;

@REIPluginLoaderClient
public class JEIPluginDetectorForge
implements REIPluginProvider<REIPlugin<?>> {
    private final Supplier<List<REIPluginProvider<?>>> jeiPlugins = Suppliers.memoize(() -> {
        ArrayList plugins = new ArrayList();
        JEIPluginDetector.detect((aClass, consumer) -> AnnotationUtils.scanAnnotation((Class)aClass, c -> true, (TriConsumer)consumer), (modIds, clazz, e) -> {
            for (ModFileScanData data : ModList.get().getAllScanData()) {
                for (ModFileScanData.AnnotationData annotation : data.getAnnotations()) {
                    if (!annotation.memberName().equals(clazz.getName()) || !annotation.annotationType().getClassName().equals("me.shedaniel.rei.plugincompatibilities.api.REIPluginCompatIgnore")) continue;
                    InternalLogger.getInstance().info("Detected JEI plugin from [%s] but IGNORED: %s".formatted(String.join((CharSequence)", ", modIds), clazz.getName()));
                    return;
                }
            }
            plugins.add((REIPluginProvider)e.get());
        });
        InternalLogger.getInstance().info("Detected %d JEI plugins".formatted(plugins.size()));
        return plugins;
    });

    public Collection<REIPlugin<?>> provide() {
        return this.jeiPlugins.get().stream().flatMap(provider -> provider.provide().stream()).collect(Collectors.toList());
    }

    public Class<REIPlugin<?>> getPluginProviderClass() {
        return REIPlugin.class;
    }

    public String getPluginProviderName() {
        return "REI Plugin Compatibilities Adapter";
    }
}

