/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.jeicompat.wrap;

import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.List;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.DisplayRenderer;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.display.DisplayCategoryView;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.client.registry.display.DynamicDisplayGenerator;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.jeicompat.JEIPluginDetector;
import me.shedaniel.rei.jeicompat.unwrap.JEIDynamicDisplayGenerator;
import me.shedaniel.rei.jeicompat.wrap.JEIDisplaySetup;
import me.shedaniel.rei.jeicompat.wrap.JEIJeiHelpers;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.advanced.IRecipeManagerPlugin;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.category.extensions.IRecipeCategoryDecorator;
import mezz.jei.api.registration.IAdvancedRegistration;
import org.jetbrains.annotations.NotNull;

public enum JEIAdvancedRegistration implements IAdvancedRegistration
{
    INSTANCE;


    @Override
    @NotNull
    public IJeiHelpers getJeiHelpers() {
        return JEIJeiHelpers.INSTANCE;
    }

    @Override
    public void addRecipeManagerPlugin(@NotNull IRecipeManagerPlugin plugin) {
        DisplayRegistry.getInstance().registerGlobalDisplayGenerator((DynamicDisplayGenerator)new JEIDynamicDisplayGenerator(plugin));
    }

    @Override
    public <T> void addRecipeCategoryDecorator(RecipeType<T> recipeType, final IRecipeCategoryDecorator<T> decorator) {
        CategoryRegistry.getInstance().configure(JEIPluginDetector.categoryId(recipeType), config -> config.registerExtension((display, category, lastView) -> new DisplayCategoryView<Display>(){

            public DisplayRenderer getDisplayRenderer(Display display) {
                return lastView.getDisplayRenderer(display);
            }

            public List<Widget> setupDisplay(Display display, Rectangle bounds) {
                ArrayList<Widget> widgets = new ArrayList<Widget>(lastView.setupDisplay(display, bounds));
                Object recipe = MoreObjects.firstNonNull((Object)JEIPluginDetector.jeiValue(display), (Object)display);
                IRecipeCategory<?> jeiCategory = JEIPluginDetector.wrapCategory(category);
                JEIDisplaySetup.Result slotsView = JEIDisplaySetup.Result.fromWidgets(widgets);
                widgets.add(Widgets.createDrawableWidget((graphics, mouseX, mouseY, delta) -> decorator.draw(recipe, jeiCategory, slotsView, graphics, mouseX, mouseY)));
                return widgets;
            }
        }));
    }
}

