/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.jeicompat.wrap;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import me.shedaniel.rei.jeicompat.wrap.JEIGuiHelper;
import mezz.jei.api.gui.ITickTimer;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableBuilder;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

public class JEIDrawableBuilder
implements IDrawableBuilder {
    private ResourceLocation texture;
    private int u;
    private int v;
    private int width;
    private int height;
    private int textureWidth = 256;
    private int textureHeight = 256;
    private int paddingTop;
    private int paddingBottom;
    private int paddingLeft;
    private int paddingRight;

    public JEIDrawableBuilder(ResourceLocation texture, int u, int v, int width, int height) {
        this.texture = texture;
        this.u = u;
        this.v = v;
        this.width = width;
        this.height = height;
    }

    @Override
    @NotNull
    public IDrawableBuilder setTextureSize(int width, int height) {
        this.textureWidth = width;
        this.textureHeight = height;
        return this;
    }

    @Override
    @NotNull
    public IDrawableBuilder addPadding(int paddingTop, int paddingBottom, int paddingLeft, int paddingRight) {
        this.paddingTop = paddingTop;
        this.paddingBottom = paddingBottom;
        this.paddingLeft = paddingLeft;
        this.paddingRight = paddingRight;
        return this;
    }

    @Override
    @NotNull
    public IDrawableBuilder trim(int trimTop, int trimBottom, int trimLeft, int trimRight) {
        this.u += trimLeft;
        this.v += trimTop;
        this.width -= trimLeft + trimRight;
        this.height -= trimTop + trimBottom;
        return this;
    }

    @Override
    @NotNull
    public IDrawableStatic build() {
        final int actualWidth = this.width + this.paddingLeft + this.paddingRight;
        final int actualHeight = this.height + this.paddingTop + this.paddingBottom;
        return new IDrawableStatic(){

            @Override
            public void draw(@NotNull GuiGraphics graphics, int xOffset, int yOffset, int maskTop, int maskBottom, int maskLeft, int maskRight) {
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)JEIDrawableBuilder.this.texture);
                Matrix4f matrix = graphics.m_280168_().m_85850_().m_252922_();
                RenderSystem.setShader(GameRenderer::m_172817_);
                BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
                bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
                int xStart = xOffset + JEIDrawableBuilder.this.paddingLeft + maskLeft;
                int yStart = yOffset + JEIDrawableBuilder.this.paddingTop + maskTop;
                int u = JEIDrawableBuilder.this.u + maskLeft;
                int v = JEIDrawableBuilder.this.v + maskTop;
                int width = JEIDrawableBuilder.this.width - maskRight - maskLeft;
                int height = JEIDrawableBuilder.this.height - maskBottom - maskTop;
                float f = 1.0f / (float)JEIDrawableBuilder.this.textureWidth;
                float f1 = 1.0f / (float)JEIDrawableBuilder.this.textureHeight;
                float z = 0.0f;
                float xEnd = xStart + width;
                float yEnd = yStart + height;
                float uStart = (float)u * f;
                float uEnd = (float)(u + width) * f;
                float vStart = (float)v * f1;
                float vEnd = (float)(v + height) * f1;
                bufferBuilder.m_252986_(matrix, (float)xStart, yEnd, z).m_7421_(uStart, vEnd).m_5752_();
                bufferBuilder.m_252986_(matrix, xEnd, yEnd, z).m_7421_(uEnd, vEnd).m_5752_();
                bufferBuilder.m_252986_(matrix, xEnd, (float)yStart, z).m_7421_(uEnd, vStart).m_5752_();
                bufferBuilder.m_252986_(matrix, (float)xStart, (float)yStart, z).m_7421_(uStart, vStart).m_5752_();
                BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
            }

            @Override
            public void draw(@NotNull GuiGraphics graphics, int xOffset, int yOffset) {
                this.draw(graphics, xOffset, yOffset, 0, 0, 0, 0);
            }

            @Override
            public int getWidth() {
                return actualWidth;
            }

            @Override
            public int getHeight() {
                return actualHeight;
            }
        };
    }

    @Override
    @NotNull
    public IDrawableAnimated buildAnimated(int ticksPerCycle, @NotNull IDrawableAnimated.StartDirection startDirection, boolean inverted) {
        return JEIGuiHelper.INSTANCE.createAnimatedDrawable(this.build(), ticksPerCycle, startDirection, inverted);
    }

    @Override
    @NotNull
    public IDrawableAnimated buildAnimated(@NotNull ITickTimer tickTimer, @NotNull IDrawableAnimated.StartDirection startDirection) {
        return JEIGuiHelper.INSTANCE.createAnimatedDrawable(this.build(), tickTimer, startDirection);
    }
}

