/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.jeicompat.wrap;

import dev.architectury.event.CompoundEventResult;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.drag.DraggableStack;
import me.shedaniel.rei.api.client.gui.drag.DraggableStackVisitor;
import me.shedaniel.rei.api.client.gui.drag.DraggedAcceptorResult;
import me.shedaniel.rei.api.client.gui.drag.DraggingContext;
import me.shedaniel.rei.api.client.registry.screen.ClickArea;
import me.shedaniel.rei.api.client.registry.screen.DisplayBoundsProvider;
import me.shedaniel.rei.api.client.registry.screen.OverlayDecider;
import me.shedaniel.rei.api.client.registry.screen.ScreenRegistry;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.jeicompat.CompatPlatform;
import me.shedaniel.rei.jeicompat.JEIPluginDetector;
import me.shedaniel.rei.jeicompat.wrap.JEIFocusFactory;
import me.shedaniel.rei.jeicompat.wrap.JEIJeiHelpers;
import me.shedaniel.rei.jeicompat.wrap.JEIRecipesGui;
import mezz.jei.api.gui.handlers.IGhostIngredientHandler;
import mezz.jei.api.gui.handlers.IGlobalGuiHandler;
import mezz.jei.api.gui.handlers.IGuiClickableArea;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.gui.handlers.IGuiProperties;
import mezz.jei.api.gui.handlers.IScreenHandler;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.runtime.IClickableIngredient;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.data.models.blockstates.PropertyDispatch;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Unit;
import net.minecraft.world.InteractionResult;
import org.jetbrains.annotations.NotNull;

public enum JEIGuiHandlerRegistration implements IGuiHandlerRegistration
{
    INSTANCE;


    @Override
    public IJeiHelpers getJeiHelpers() {
        return JEIJeiHelpers.INSTANCE;
    }

    @Override
    public <T extends AbstractContainerScreen<?>> void addGuiContainerHandler(@NotNull Class<? extends T> guiClass, @NotNull IGuiContainerHandler<T> guiHandler) {
        this.add(guiClass, guiHandler::getGuiExtraAreas, guiHandler::getClickableIngredientUnderMouse);
        ScreenRegistry.getInstance().registerClickArea(guiClass, context -> {
            Point mouse;
            AbstractContainerScreen screen = (AbstractContainerScreen)context.getScreen();
            Collection<IGuiClickableArea> areas = guiHandler.getGuiClickableAreas(screen, (mouse = context.getMousePosition()).getX() - CompatPlatform.get().getGuiLeft(screen), mouse.getY() - CompatPlatform.get().getGuiTop(screen));
            if (areas != null) {
                for (IGuiClickableArea area : areas) {
                    if (!area.getArea().m_110087_(mouse.getX() - CompatPlatform.get().getGuiLeft(screen), mouse.getY() - CompatPlatform.get().getGuiTop(screen))) continue;
                    return ClickArea.Result.success().executor(() -> {
                        area.onClick(JEIFocusFactory.INSTANCE, JEIRecipesGui.INSTANCE);
                        return true;
                    }).tooltip(() -> area.getTooltipStrings().toArray(new Component[0]));
                }
            }
            return ClickArea.Result.fail();
        });
    }

    @Override
    public <T extends AbstractContainerScreen<?>> void addGenericGuiContainerHandler(@NotNull Class<? extends T> guiClass, @NotNull IGuiContainerHandler<?> guiHandler) {
        this.addGuiContainerHandler(guiClass, guiHandler);
    }

    @Override
    public <T extends Screen> void addGuiScreenHandler(final @NotNull Class<T> guiClass, final @NotNull IScreenHandler<T> handler) {
        ScreenRegistry.getInstance().registerDecider((OverlayDecider)new DisplayBoundsProvider<T>(){

            public <R extends Screen> boolean isHandingScreen(Class<R> screen) {
                return guiClass.isAssignableFrom(screen);
            }

            public Rectangle getScreenBounds(T screen) {
                IGuiProperties properties = handler.apply(screen);
                if (properties == null) {
                    return null;
                }
                return new Rectangle(properties.getGuiLeft(), properties.getGuiTop(), properties.getGuiXSize(), properties.getGuiYSize());
            }

            public <R extends Screen> InteractionResult shouldScreenBeOverlaid(R screen) {
                IGuiProperties properties;
                if (screen == null) {
                    return InteractionResult.PASS;
                }
                if (this.isHandingScreen(screen.getClass()) && (properties = handler.apply(screen)) == null) {
                    return InteractionResult.FAIL;
                }
                return InteractionResult.PASS;
            }
        });
    }

    @Override
    public void addGlobalGuiHandler(@NotNull IGlobalGuiHandler globalGuiHandler) {
        this.add(Screen.class, screen -> globalGuiHandler.getGuiExtraAreas(), (screen, mouseX, mouseY) -> globalGuiHandler.getClickableIngredientUnderMouse((double)mouseX, (double)mouseY));
    }

    private <T extends Screen> void add(Class<? extends T> screenClass, Function<T, Collection<Rect2i>> exclusionZones, PropertyDispatch.TriFunction<T, Double, Double, Optional<IClickableIngredient<?>>> focusedStack) {
        ScreenRegistry.getInstance().exclusionZones().register(screenClass, screen -> CollectionUtils.map((Collection)((Collection)exclusionZones.apply(screen)), rect2i -> new Rectangle(rect2i.m_110085_(), rect2i.m_110086_(), rect2i.m_110090_(), rect2i.m_110091_())));
        ScreenRegistry.getInstance().registerFocusedStack((screen, mouse) -> {
            if (!screenClass.isInstance(screen)) {
                return CompoundEventResult.pass();
            }
            Optional ingredient = (Optional)focusedStack.m_125475_((Object)screen, (Object)mouse.x, (Object)mouse.y);
            if (ingredient.isEmpty()) {
                return CompoundEventResult.pass();
            }
            return CompoundEventResult.interruptTrue(JEIPluginDetector.unwrapStack(ingredient.get()));
        });
    }

    @Override
    public <T extends Screen> void addGhostIngredientHandler(final @NotNull Class<T> guiClass, final @NotNull IGhostIngredientHandler<T> handler) {
        ScreenRegistry.getInstance().registerDraggableStackVisitor(new DraggableStackVisitor<T>(){

            public Optional<IGhostIngredientHandler.Target<Object>> canAccept(DraggingContext<T> context, DraggableStack stack) {
                List list = handler.getTargetsTyped(context.getScreen(), JEIPluginDetector.typedJeiValue(stack.getStack()), true);
                for (IGhostIngredientHandler.Target target : list) {
                    if (!target.getArea().m_110087_(context.getCurrentPosition().x, context.getCurrentPosition().y)) continue;
                    return Optional.of(target);
                }
                return Optional.empty();
            }

            public DraggedAcceptorResult acceptDraggedStack(DraggingContext<T> context, DraggableStack stack) {
                return this.canAccept(context, stack).map(target -> {
                    target.accept(JEIPluginDetector.jeiValue(stack.getStack().copy()));
                    return Unit.INSTANCE;
                }).isPresent() ? DraggedAcceptorResult.ACCEPTED : DraggedAcceptorResult.PASS;
            }

            public Stream<DraggableStackVisitor.BoundsProvider> getDraggableAcceptingBounds(DraggingContext<T> context, DraggableStack stack) {
                return Stream.of(DraggableStackVisitor.BoundsProvider.ofRectangles(() -> handler.getTargetsTyped(context.getScreen(), JEIPluginDetector.typedJeiValue(stack.getStack()), true).stream().map(IGhostIngredientHandler.Target::getArea).map(rect2i -> new Rectangle(rect2i.m_110085_(), rect2i.m_110086_(), rect2i.m_110090_(), rect2i.m_110091_())).iterator()));
            }

            public <R extends Screen> boolean isHandingScreen(R screen) {
                return guiClass.isInstance(screen);
            }
        });
    }
}

