/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.jeicompat.wrap;

import java.util.Optional;
import java.util.stream.Stream;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.jeicompat.CompatPlatform;
import me.shedaniel.rei.jeicompat.JEIPluginDetector;
import me.shedaniel.rei.jeicompat.imitator.JEiColorGetterImitator;
import me.shedaniel.rei.jeicompat.wrap.JEIFocusFactory;
import me.shedaniel.rei.jeicompat.wrap.JEIGuiHelper;
import me.shedaniel.rei.jeicompat.wrap.JEIIngredientManager;
import me.shedaniel.rei.jeicompat.wrap.JEIModIdHelper;
import me.shedaniel.rei.jeicompat.wrap.JEIStackHelper;
import mezz.jei.api.helpers.IColorHelper;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.helpers.IModIdHelper;
import mezz.jei.api.helpers.IPlatformFluidHelper;
import mezz.jei.api.helpers.IStackHelper;
import mezz.jei.api.recipe.IFocusFactory;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.runtime.IIngredientManager;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public enum JEIJeiHelpers implements IJeiHelpers
{
    INSTANCE;


    @Override
    @NotNull
    public IGuiHelper getGuiHelper() {
        return JEIGuiHelper.INSTANCE;
    }

    @Override
    @NotNull
    public IStackHelper getStackHelper() {
        return JEIStackHelper.INSTANCE;
    }

    @Override
    @NotNull
    public IModIdHelper getModIdHelper() {
        return JEIModIdHelper.INSTANCE;
    }

    @Override
    public IFocusFactory getFocusFactory() {
        return JEIFocusFactory.INSTANCE;
    }

    @Override
    public IColorHelper getColorHelper() {
        return JEiColorGetterImitator.INSTANCE;
    }

    @Override
    public IPlatformFluidHelper<?> getPlatformFluidHelper() {
        return CompatPlatform.get().getPlatformFluidHelper();
    }

    @Override
    public Optional<RecipeType<?>> getRecipeType(ResourceLocation uid) {
        return CategoryRegistry.getInstance().tryGet(JEIPluginDetector.categoryId(uid)).map($ -> JEIPluginDetector.asRecipeType(uid, Object.class));
    }

    @Override
    public Stream<RecipeType<?>> getAllRecipeTypes() {
        return CategoryRegistry.getInstance().stream().map(config -> JEIPluginDetector.asRecipeType(config.getCategoryIdentifier(), Object.class));
    }

    @Override
    public IIngredientManager getIngredientManager() {
        return JEIIngredientManager.INSTANCE;
    }
}

