/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.jeicompat.wrap;

import com.google.common.base.MoreObjects;
import dev.architectury.event.EventResult;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.category.visibility.CategoryVisibilityPredicate;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.client.registry.display.visibility.DisplayVisibilityPredicate;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.jeicompat.JEIPluginDetector;
import me.shedaniel.rei.jeicompat.wrap.JEICatalystLookup;
import me.shedaniel.rei.jeicompat.wrap.JEIRecipeCategoriesLookup;
import me.shedaniel.rei.jeicompat.wrap.JEIRecipeLookup;
import me.shedaniel.rei.jeicompat.wrap.JEIRecipeRegistration;
import mezz.jei.api.gui.IRecipeLayoutDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotDrawable;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.IRecipeCatalystLookup;
import mezz.jei.api.recipe.IRecipeCategoriesLookup;
import mezz.jei.api.recipe.IRecipeLookup;
import mezz.jei.api.recipe.IRecipeManager;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.resources.ResourceLocation;

public enum JEIRecipeManager implements IRecipeManager
{
    INSTANCE;

    Set<CategoryIdentifier<?>> hiddenCategories = new HashSet();
    Map<CategoryIdentifier<?>, Set<Object>> hiddenRecipes = new HashMap();
    public DisplayPredicate displayPredicate = new DisplayPredicate();
    public CategoryPredicate categoryPredicate = new CategoryPredicate();

    @Override
    public <R> IRecipeLookup<R> createRecipeLookup(RecipeType<R> recipeType) {
        return new JEIRecipeLookup(JEIPluginDetector.categoryId(recipeType));
    }

    @Override
    public IRecipeCategoriesLookup createRecipeCategoryLookup() {
        return new JEIRecipeCategoriesLookup();
    }

    @Override
    public IRecipeCatalystLookup createRecipeCatalystLookup(RecipeType<?> recipeType) {
        return new JEICatalystLookup(JEIPluginDetector.categoryId(recipeType));
    }

    @Override
    public <T> void hideRecipes(RecipeType<T> recipeType, Collection<T> recipes) {
        this.hiddenRecipes.computeIfAbsent(JEIPluginDetector.categoryId(recipeType), $ -> new HashSet()).addAll(recipes);
    }

    @Override
    public <T> void unhideRecipes(RecipeType<T> recipeType, Collection<T> recipes) {
        CategoryIdentifier categoryIdentifier = JEIPluginDetector.categoryId(recipeType);
        this.hiddenRecipes.computeIfAbsent(categoryIdentifier, $ -> new HashSet()).removeAll(recipes);
        if (this.hiddenRecipes.get(categoryIdentifier).isEmpty()) {
            this.hiddenRecipes.remove(categoryIdentifier);
        }
    }

    @Override
    public <T> void addRecipes(RecipeType<T> recipeType, List<T> recipes) {
        JEIRecipeRegistration.addRecipes0(recipes, recipeType.getUid());
    }

    @Override
    public void hideRecipeCategory(RecipeType<?> recipeType) {
        this.hiddenCategories.add(JEIPluginDetector.categoryId(recipeType));
    }

    @Override
    public void unhideRecipeCategory(RecipeType<?> recipeType) {
        this.hiddenCategories.remove(JEIPluginDetector.categoryId(recipeType));
    }

    @Override
    public <T> Optional<IRecipeLayoutDrawable<T>> createRecipeLayoutDrawable(IRecipeCategory<T> recipeCategory, T recipe, IFocusGroup focusGroup) {
        throw JEIPluginDetector.TODO();
    }

    @Override
    public IRecipeSlotDrawable createRecipeSlotDrawable(RecipeIngredientRole role, List<Optional<ITypedIngredient<?>>> ingredients, Set<Integer> focusedIngredients, int xPos, int yPos, int ingredientCycleOffset) {
        throw JEIPluginDetector.TODO();
    }

    @Override
    public Optional<RecipeType<?>> getRecipeType(ResourceLocation uid) {
        return CategoryRegistry.getInstance().tryGet(JEIPluginDetector.categoryId(uid)).map($ -> JEIPluginDetector.asRecipeType(uid, Object.class));
    }

    public class DisplayPredicate
    implements DisplayVisibilityPredicate {
        public EventResult handleDisplay(DisplayCategory<?> category, Display display) {
            Set<Object> hidden = JEIRecipeManager.this.hiddenRecipes.get(category.getCategoryIdentifier());
            if (hidden != null && hidden.contains(MoreObjects.firstNonNull((Object)JEIPluginDetector.jeiValue(display), (Object)display))) {
                return EventResult.interruptFalse();
            }
            return EventResult.pass();
        }
    }

    public class CategoryPredicate
    implements CategoryVisibilityPredicate {
        public EventResult handleCategory(DisplayCategory<?> category) {
            if (JEIRecipeManager.this.hiddenCategories.contains(category.getCategoryIdentifier())) {
                return EventResult.interruptFalse();
            }
            return EventResult.pass();
        }
    }
}

