/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.jeicompat.wrap;

import com.google.common.base.MoreObjects;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.client.ClientTooltipEvent;
import dev.architectury.utils.value.Value;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.client.registry.transfer.TransferHandler;
import me.shedaniel.rei.api.client.registry.transfer.TransferHandlerRegistry;
import me.shedaniel.rei.api.client.registry.transfer.TransferHandlerRenderer;
import me.shedaniel.rei.api.client.registry.transfer.simple.SimpleTransferHandler;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.transfer.info.stack.SlotAccessor;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.impl.common.InternalLogger;
import me.shedaniel.rei.jeicompat.ClientTextTooltipInterface;
import me.shedaniel.rei.jeicompat.JEIPluginDetector;
import me.shedaniel.rei.jeicompat.wrap.ForwardRecipeSlotView;
import me.shedaniel.rei.jeicompat.wrap.ForwardRecipeSlotsView;
import me.shedaniel.rei.jeicompat.wrap.JEIDisplaySetup;
import me.shedaniel.rei.jeicompat.wrap.JEIGuiHelper;
import me.shedaniel.rei.jeicompat.wrap.JEIJeiHelpers;
import me.shedaniel.rei.jeicompat.wrap.JEIRecipeLayoutBuilder;
import me.shedaniel.rei.jeicompat.wrap.JEIRecipeSlot;
import me.shedaniel.rei.jeicompat.wrap.JEIRecipeTransferError;
import me.shedaniel.rei.jeicompat.wrap.JEIRecipeTransferErrorWrapped;
import me.shedaniel.rei.jeicompat.wrap.JEIRecipeTransferHandlerHelper;
import me.shedaniel.rei.jeicompat.wrap.JEIWrappedCategory;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import mezz.jei.api.recipe.transfer.IRecipeTransferInfo;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTextTooltip;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JEIRecipeTransferRegistration
implements IRecipeTransferRegistration {
    private static ClientTooltipEvent.Render tooltipEventConsumer;
    private final Consumer<Runnable> post;
    private Function<Point, Tooltip> tooltip = null;

    public JEIRecipeTransferRegistration(Consumer<Runnable> post) {
        this.post = post;
    }

    @Override
    @NotNull
    public IJeiHelpers getJeiHelpers() {
        return JEIJeiHelpers.INSTANCE;
    }

    @Override
    @NotNull
    public IRecipeTransferHandlerHelper getTransferHelper() {
        return new JEIRecipeTransferHandlerHelper(this.post);
    }

    @Override
    public <C extends AbstractContainerMenu, R> void addRecipeTransferHandler(Class<? extends C> containerClass, @Nullable MenuType<C> menuType, RecipeType<R> recipeType, int recipeSlotStart, int recipeSlotCount, int inventorySlotStart, int inventorySlotCount) {
        this.addRecipeTransferHandler(this.getTransferHelper().createBasicRecipeTransferInfo(containerClass, menuType, recipeType, recipeSlotStart, recipeSlotCount, inventorySlotStart, inventorySlotCount));
    }

    @Override
    public <C extends AbstractContainerMenu, R> void addRecipeTransferHandler(final IRecipeTransferInfo<C, R> info) {
        UUID uuid = UUID.randomUUID();
        InternalLogger.getInstance().debug("Queued registration of JEI recipe transfer handler: " + JEIPluginDetector.categoryId(info.getRecipeType()) + " " + info.getContainerClass() + " " + uuid);
        this.post.accept(() -> {
            InternalLogger.getInstance().debug("Registered JEI recipe transfer handler: " + JEIPluginDetector.categoryId(info.getRecipeType()) + " " + info.getContainerClass() + " " + uuid);
            TransferHandlerRegistry.getInstance().register((TransferHandler)new SimpleTransferHandler(){
                private final CategoryIdentifier<?> categoryIdentifier;
                {
                    this.categoryIdentifier = JEIPluginDetector.categoryId(info.getRecipeType());
                }

                public TransferHandler.ApplicabilityResult checkApplicable(TransferHandler.Context context) {
                    Object jeiValue = JEIPluginDetector.jeiValue(context.getDisplay());
                    if (!info.getContainerClass().isInstance(context.getMenu()) || !this.categoryIdentifier.equals((Object)context.getDisplay().getCategoryIdentifier()) || context.getContainerScreen() == null || jeiValue == null) {
                        return TransferHandler.ApplicabilityResult.createNotApplicable();
                    }
                    if (!info.canHandle(context.getMenu(), jeiValue)) {
                        IRecipeTransferError error = info.getHandlingError(context.getMenu(), jeiValue);
                        TransferHandler.Result result = JEIRecipeTransferRegistration.this.ofError(error, new Rectangle[]{new Rectangle()}, null);
                        if (result.isApplicable()) {
                            return TransferHandler.ApplicabilityResult.createApplicableWithError((TransferHandler.Result)result);
                        }
                        return TransferHandler.ApplicabilityResult.createNotApplicable();
                    }
                    return TransferHandler.ApplicabilityResult.createApplicable();
                }

                public Iterable<SlotAccessor> getInputSlots(TransferHandler.Context context) {
                    Object jeiValue = JEIPluginDetector.jeiValue(context.getDisplay());
                    List<Slot> slots = info.getRecipeSlots(context.getMenu(), jeiValue);
                    return Iterables.transform(slots, SlotAccessor::fromSlot);
                }

                public Iterable<SlotAccessor> getInventorySlots(TransferHandler.Context context) {
                    Object jeiValue = JEIPluginDetector.jeiValue(context.getDisplay());
                    List<Slot> slots = info.getInventorySlots(context.getMenu(), jeiValue);
                    return Iterables.transform(slots, SlotAccessor::fromSlot);
                }
            });
        });
    }

    @Override
    public <C extends AbstractContainerMenu, R> void addRecipeTransferHandler(final IRecipeTransferHandler<C, R> recipeTransferHandler, final RecipeType<R> recipeCategoryUid) {
        TransferHandlerRegistry.getInstance().register(new TransferHandler(){

            public TransferHandler.Result handle(TransferHandler.Context context) {
                if (recipeTransferHandler.getContainerClass().isInstance(context.getMenu())) {
                    Display display = context.getDisplay();
                    if (recipeCategoryUid == null || display.getCategoryIdentifier().equals(JEIPluginDetector.categoryId(recipeCategoryUid))) {
                        Value<IDrawable> background = new Value<IDrawable>(){

                            public void accept(IDrawable iDrawable) {
                            }

                            public IDrawable get() {
                                return JEIGuiHelper.INSTANCE.createBlankDrawable(0, 0);
                            }
                        };
                        IRecipeSlotsView[] view = new IRecipeSlotsView[]{JEIDisplaySetup.Result.fromREI(display)};
                        if (context.isActuallyCrafting()) {
                            context.getMinecraft().m_91152_((Screen)context.getContainerScreen());
                        }
                        IRecipeTransferHandler handler = recipeTransferHandler;
                        Object recipe = MoreObjects.firstNonNull((Object)JEIPluginDetector.jeiValue(display), (Object)display);
                        final Rectangle[] b = new Rectangle[]{new Rectangle()};
                        view[0] = new ForwardRecipeSlotsView(view[0], slot -> new ForwardRecipeSlotView((IRecipeSlotView)slot){

                            @Override
                            public void drawHighlight(GuiGraphics stack, int color) {
                                stack.m_280168_().m_85836_();
                                stack.m_280168_().m_252880_((float)(-b[0].x), (float)(-b[0].y), 0.0f);
                                super.drawHighlight(stack, color);
                                stack.m_280168_().m_85849_();
                            }
                        });
                        IRecipeTransferError error = handler.transferRecipe(context.getMenu(), recipe, view[0], (Player)context.getMinecraft().f_91074_, context.isStackedCrafting(), context.isActuallyCrafting());
                        return JEIRecipeTransferRegistration.this.ofError(error, b, view[0]);
                    }
                }
                return TransferHandler.Result.createNotApplicable();
            }
        });
    }

    private TransferHandler.Result ofError(IRecipeTransferError error, Rectangle[] b, @Nullable IRecipeSlotsView view) {
        TransferHandler.Result result;
        if (error instanceof JEIRecipeTransferErrorWrapped) {
            return ((JEIRecipeTransferErrorWrapped)error).getResult();
        }
        if (error == null) {
            return TransferHandler.Result.createSuccessful();
        }
        IRecipeTransferError.Type type = error.getType();
        if (type == IRecipeTransferError.Type.INTERNAL) {
            return TransferHandler.Result.createNotApplicable();
        }
        TransferHandler.Result result2 = type == IRecipeTransferError.Type.COSMETIC ? TransferHandler.Result.createSuccessful() : (result = TransferHandler.Result.createFailed((Component)(error instanceof JEIRecipeTransferError ? ((JEIRecipeTransferError)error).getText() : Component.m_237113_((String)""))));
        if (type != IRecipeTransferError.Type.COSMETIC) {
            result.color(error.getButtonHighlightColor());
        }
        if (error instanceof JEIRecipeTransferError) {
            JEIRecipeTransferError transferError = (JEIRecipeTransferError)error;
            if (error instanceof JEIRecipeTransferError) {
                result.renderer(JEIRecipeTransferRegistration.forRedSlots(b, ((JEIRecipeTransferError)error).getRedSlots()));
            }
            return result;
        }
        IRecipeTransferError finalError = error;
        return result.overrideTooltipRenderer((point, tooltipSink) -> {
            if (this.tooltip != null) {
                tooltipSink.accept(this.tooltip.apply((Point)point));
                this.tooltip = null;
            }
        }).renderer((matrices, mouseX, mouseY, delta, widgets, bounds, d) -> {
            b[0] = bounds;
            this.tooltip = null;
            tooltipEventConsumer = (mat, texts, x, y) -> {
                this.tooltip = point -> {
                    Tooltip tool = Tooltip.create((Point)point, (Component[])new Component[0]);
                    for (ClientTooltipComponent component : texts) {
                        if (!(component instanceof ClientTextTooltip)) continue;
                        FormattedCharSequence sequence = ((ClientTextTooltipInterface)component).reipc$getText();
                        MutableComponent[] mutableComponents = new MutableComponent[]{Component.m_237113_((String)"")};
                        sequence.m_13731_((index, style, codepoint) -> {
                            mutableComponents[0].m_7220_((Component)Component.m_237113_((String)new String(new int[]{codepoint}, 0, 1)).m_6270_(style));
                            return true;
                        });
                        tool.add((Component)mutableComponents[0]);
                    }
                    return tool;
                };
                return EventResult.interruptFalse();
            };
            if (view != null) {
                matrices.m_280168_().m_85836_();
                finalError.showError(matrices, mouseX, mouseY, view, 4, 4);
                matrices.m_280168_().m_85849_();
            }
            tooltipEventConsumer = null;
        });
    }

    static TransferHandlerRenderer forRedSlots(IntList redSlots) {
        return (graphics, mouseX, mouseY, delta, widgets, bounds, display) -> {
            DisplayCategory category = Objects.requireNonNull(CategoryRegistry.getInstance().get(display.getCategoryIdentifier())).getCategory();
            if (category instanceof JEIWrappedCategory) {
                JEIWrappedCategory wrappedCategory = (JEIWrappedCategory)category;
                int i = 0;
                for (me.shedaniel.rei.api.client.gui.widgets.Slot slot : Widgets.walk((Iterable)widgets, widget -> widget instanceof me.shedaniel.rei.api.client.gui.widgets.Slot)) {
                    if (slot.getNoticeMark() == 1 && redSlots.contains(i)) {
                        graphics.m_280168_().m_85836_();
                        graphics.m_280168_().m_252880_(0.0f, 0.0f, 400.0f);
                        Rectangle innerBounds = slot.getInnerBounds();
                        graphics.m_280509_(innerBounds.x, innerBounds.y, innerBounds.getMaxX(), innerBounds.getMaxY(), 0x40FF0000);
                        graphics.m_280168_().m_85849_();
                    }
                    ++i;
                }
            }
        };
    }

    static TransferHandlerRenderer forRedSlots(Rectangle[] b, Collection<IRecipeSlotView> redSlots) {
        return (graphics, mouseX, mouseY, delta, widgets, bounds, display) -> {
            b[0] = new Rectangle(-bounds.x, -bounds.y, 1, 1);
            DisplayCategory category = Objects.requireNonNull(CategoryRegistry.getInstance().get(display.getCategoryIdentifier())).getCategory();
            if (category instanceof JEIWrappedCategory) {
                JEIWrappedCategory wrappedCategory = (JEIWrappedCategory)category;
                int i = 0;
                for (me.shedaniel.rei.api.client.gui.widgets.Slot slot : Widgets.walk((Iterable)widgets, widget -> widget instanceof me.shedaniel.rei.api.client.gui.widgets.Slot)) {
                    if (redSlots.stream().anyMatch(redSlot -> ((JEIRecipeSlot)redSlot).slot == slot)) {
                        graphics.m_280168_().m_85836_();
                        graphics.m_280168_().m_252880_(0.0f, 0.0f, 400.0f);
                        Rectangle innerBounds = slot.getInnerBounds();
                        graphics.m_280509_(innerBounds.x, innerBounds.y, innerBounds.getMaxX(), innerBounds.getMaxY(), 0x40FF0000);
                        graphics.m_280168_().m_85849_();
                    }
                    ++i;
                }
            } else {
                graphics.m_280168_().m_85836_();
                graphics.m_280168_().m_252880_(4.0f, 4.0f, 400.0f);
                for (IRecipeSlotView missingSlot : redSlots) {
                    missingSlot.drawHighlight(graphics, 0x40FF0000);
                }
                graphics.m_280168_().m_85849_();
            }
        };
    }

    public static void addToLayout(JEIRecipeLayoutBuilder builder, List<Widget> entries, int xOffset, int yOffset) {
        HashMap<Boolean, List> groups = new HashMap<Boolean, List>();
        for (Widget widget : entries) {
            if (!(widget instanceof me.shedaniel.rei.api.client.gui.widgets.Slot)) continue;
            HashMultimap group = HashMultimap.create();
            List ingredient = ((me.shedaniel.rei.api.client.gui.widgets.Slot)widget).getEntries();
            for (EntryStack stack : ingredient) {
                if (stack.isEmpty()) continue;
                group.put((Object)stack.getType(), (Object)stack);
            }
            groups.computeIfAbsent(((me.shedaniel.rei.api.client.gui.widgets.Slot)widget).getNoticeMark() != 2, $ -> new ArrayList()).add(Pair.of((Object)((me.shedaniel.rei.api.client.gui.widgets.Slot)widget), (Object)group));
        }
        for (Map.Entry entry : groups.entrySet()) {
            ((List)entry.getValue()).stream().map(Pair::getRight).map(Multimap::keys).flatMap(Collection::stream).distinct().forEach(type -> {
                for (Pair pair : (List)entry.getValue()) {
                    me.shedaniel.rei.api.client.gui.widgets.Slot slot = (me.shedaniel.rei.api.client.gui.widgets.Slot)pair.getLeft();
                    Collection stacks = ((Multimap)pair.getRight()).get(type);
                    builder.addSlot((Boolean)entry.getKey() != false ? RecipeIngredientRole.INPUT : RecipeIngredientRole.OUTPUT, slot.getInnerBounds().x - xOffset, slot.getInnerBounds().y - yOffset).addIngredientsUnsafe(CollectionUtils.map((Collection)stacks, JEIPluginDetector::jeiValue));
                }
            });
        }
    }

    @Override
    public <C extends AbstractContainerMenu, R> void addUniversalRecipeTransferHandler(IRecipeTransferHandler<C, R> recipeTransferHandler) {
        this.addRecipeTransferHandler(recipeTransferHandler, null);
    }

    static {
        ClientTooltipEvent.RENDER_PRE.register((matrices, texts, x, y) -> {
            if (tooltipEventConsumer != null) {
                return tooltipEventConsumer.renderTooltip(matrices, texts, x, y);
            }
            return EventResult.pass();
        });
    }
}

