/*
 * Decompiled with CFR 0.152.
 */
package terrablender.config;

import java.nio.file.Path;
import terrablender.config.Config;
import terrablender.config.ConfigFile;

public class TerraBlenderConfig
extends ConfigFile {
    public final int overworldRegionSize;
    public final int netherRegionSize;
    public final int vanillaOverworldRegionWeight;
    public final int vanillaNetherRegionWeight;

    public TerraBlenderConfig(Path path) {
        super(path);
        Config generalConfig = this.getSubConfig("general");
        this.addSubConfig("General settings", "general", generalConfig);
        Config generationSettings = this.getSubConfig("generation_settings");
        this.overworldRegionSize = generationSettings.addNumber("The size of overworld biome regions from each mod that uses TerraBlender.", "overworld_region_size", 3, 2, 6);
        this.netherRegionSize = generationSettings.addNumber("The size of nether biome regions from each mod that uses TerraBlender.", "nether_region_size", 2, 2, 6);
        this.vanillaOverworldRegionWeight = generationSettings.addNumber("The weighting of vanilla biome regions in the overworld.", "vanilla_overworld_region_weight", 10, 0, Integer.MAX_VALUE);
        this.vanillaNetherRegionWeight = generationSettings.addNumber("The weighting of vanilla biome regions in the nether.", "vanilla_nether_region_weight", 10, 0, Integer.MAX_VALUE);
        this.addSubConfig("Generation settings", "generation_settings", generationSettings);
        this.save();
    }
}

