/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.container;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import xyz.przemyk.simpleplanes.container.slots.PlaneCargoSlot;
import xyz.przemyk.simpleplanes.container.slots.PlaneUpgradeSlot;
import xyz.przemyk.simpleplanes.datapack.PayloadEntry;
import xyz.przemyk.simpleplanes.datapack.PlanePayloadReloadListener;
import xyz.przemyk.simpleplanes.entities.CargoPlaneEntity;
import xyz.przemyk.simpleplanes.entities.LargePlaneEntity;
import xyz.przemyk.simpleplanes.entities.PlaneEntity;
import xyz.przemyk.simpleplanes.setup.SimplePlanesContainers;
import xyz.przemyk.simpleplanes.setup.SimplePlanesRegistries;
import xyz.przemyk.simpleplanes.setup.SimplePlanesUpgrades;
import xyz.przemyk.simpleplanes.upgrades.LargeUpgrade;
import xyz.przemyk.simpleplanes.upgrades.Upgrade;
import xyz.przemyk.simpleplanes.upgrades.UpgradeType;
import xyz.przemyk.simpleplanes.upgrades.payload.PayloadUpgrade;

public class ModifyUpgradesContainer
extends AbstractContainerMenu {
    private final MyItemStackHandler itemHandler = new MyItemStackHandler();
    public PlaneEntity planeEntity;
    public int errorSlot = -1;
    private boolean internalItemsChange = true;

    public ModifyUpgradesContainer(int id, Inventory playerInventory, FriendlyByteBuf buffer) {
        this(id, playerInventory, buffer.m_130242_());
    }

    public ModifyUpgradesContainer(int id, Inventory playerInventory, int planeID) {
        super((MenuType)SimplePlanesContainers.UPGRADES_REMOVAL.get(), id);
        this.m_38897_((Slot)new PlaneUpgradeSlot((IItemHandler)this.itemHandler, 0, 8, 17, this));
        this.m_38897_((Slot)new PlaneUpgradeSlot((IItemHandler)this.itemHandler, 1, 26, 17, this));
        this.m_38897_((Slot)new PlaneUpgradeSlot((IItemHandler)this.itemHandler, 2, 8, 35, this));
        this.m_38897_((Slot)new PlaneUpgradeSlot((IItemHandler)this.itemHandler, 3, 26, 35, this));
        this.m_38897_((Slot)new PlaneUpgradeSlot((IItemHandler)this.itemHandler, 4, 8, 53, this));
        this.m_38897_((Slot)new PlaneUpgradeSlot((IItemHandler)this.itemHandler, 5, 26, 53, this));
        Entity entity = playerInventory.f_35978_.m_9236_().m_6815_(planeID);
        if (entity instanceof PlaneEntity) {
            PlaneEntity planeEntity;
            this.planeEntity = planeEntity = (PlaneEntity)entity;
            if (planeEntity instanceof CargoPlaneEntity) {
                this.m_38897_((Slot)new PlaneCargoSlot((IItemHandler)this.itemHandler, 6, 26, 75));
                this.m_38897_((Slot)new PlaneCargoSlot((IItemHandler)this.itemHandler, 7, 44, 75));
                this.m_38897_((Slot)new PlaneCargoSlot((IItemHandler)this.itemHandler, 8, 62, 75));
                this.m_38897_((Slot)new PlaneCargoSlot((IItemHandler)this.itemHandler, 9, 80, 75));
                this.m_38897_((Slot)new PlaneCargoSlot((IItemHandler)this.itemHandler, 10, 98, 75));
                this.m_38897_((Slot)new PlaneCargoSlot((IItemHandler)this.itemHandler, 11, 116, 75));
                this.m_38897_((Slot)new PlaneCargoSlot((IItemHandler)this.itemHandler, 12, 134, 75));
                this.m_38897_((Slot)new PlaneCargoSlot((IItemHandler)this.itemHandler, 13, 152, 75));
            }
            int i = 0;
            for (Upgrade upgrade : planeEntity.upgrades.values()) {
                this.itemHandler.setStackInSlot(i, upgrade.getItemStack());
                if (i >= 5) break;
                ++i;
            }
            i = 6;
            if (entity instanceof CargoPlaneEntity) {
                CargoPlaneEntity cargoPlaneEntity = (CargoPlaneEntity)entity;
                for (LargeUpgrade upgrade : cargoPlaneEntity.largeUpgrades) {
                    this.itemHandler.setStackInSlot(i, upgrade.getItemStack());
                    ++i;
                }
            }
        }
        this.internalItemsChange = false;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, 102 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.m_38897_(new Slot((Container)playerInventory, k, 8 + k * 18, 160));
        }
    }

    public void itemsChanged(ItemStack previousStack, ItemStack newStack, int slot) {
        if (this.planeEntity.m_9236_().f_46443_ || this.internalItemsChange || ItemStack.m_150942_((ItemStack)previousStack, (ItemStack)newStack)) {
            return;
        }
        if (slot < 6) {
            AtomicBoolean success = new AtomicBoolean(false);
            if (!previousStack.m_41619_()) {
                PayloadEntry payloadEntry;
                Item item = previousStack.m_41720_();
                UpgradeType upgradeType = SimplePlanesUpgrades.getUpgradeFromItem(item).orElse(SimplePlanesUpgrades.getLargeUpgradeFromItem(item).orElse(null));
                if (upgradeType == null && (payloadEntry = PlanePayloadReloadListener.payloadEntries.get(item)) != null) {
                    upgradeType = (UpgradeType)SimplePlanesUpgrades.PAYLOAD.get();
                }
                if (upgradeType != null) {
                    ResourceLocation resourceLocation = SimplePlanesRegistries.UPGRADE_TYPES.get().getKey((Object)upgradeType);
                    Upgrade upgrade = this.planeEntity.upgrades.get(resourceLocation);
                    if (upgrade != null && ItemStack.m_150942_((ItemStack)previousStack, (ItemStack)upgrade.getItemStack())) {
                        ItemStack itemStack = ItemStack.f_41583_;
                        for (int i = 0; i < 6; ++i) {
                            if (i == slot) continue;
                            itemStack = this.itemHandler.getStackInSlot(i);
                            if (ItemStack.m_41656_((ItemStack)previousStack, (ItemStack)itemStack)) break;
                            itemStack = ItemStack.f_41583_;
                        }
                        if (!itemStack.m_41619_()) {
                            if (!ItemStack.m_150942_((ItemStack)previousStack, (ItemStack)itemStack)) {
                                this.planeEntity.removeUpgrade(resourceLocation);
                                this.tryUpgradeFromItem(itemStack, success);
                            }
                        } else {
                            this.planeEntity.removeUpgrade(resourceLocation);
                        }
                    }
                    success.set(true);
                }
            }
            if (!newStack.m_41619_()) {
                this.tryUpgradeFromItem(newStack, success);
            }
            if (success.get()) {
                if (this.errorSlot == slot) {
                    this.errorSlot = -1;
                }
            } else {
                this.errorSlot = slot;
            }
        } else {
            PlaneEntity success = this.planeEntity;
            if (success instanceof CargoPlaneEntity) {
                CargoPlaneEntity cargoPlaneEntity = (CargoPlaneEntity)success;
                if (newStack.m_41619_()) {
                    cargoPlaneEntity.removeCargoUpgrade(slot - 6);
                    this.itemHandler.removeAndShift(slot);
                } else if (slot > 6) {
                    for (int i = 6; i < slot; ++i) {
                        if (!this.itemHandler.getStackInSlot(i).m_41619_()) continue;
                        this.internalItemsChange = true;
                        this.itemHandler.setStackInSlot(i, newStack);
                        this.itemHandler.setStackInSlot(slot, ItemStack.f_41583_);
                        this.internalItemsChange = false;
                        break;
                    }
                    if (!cargoPlaneEntity.m_9236_().f_46443_) {
                        UpgradeType upgradeType = SimplePlanesUpgrades.LARGE_ITEM_UPGRADE_MAP.get(newStack.m_41720_());
                        if (upgradeType != null) {
                            cargoPlaneEntity.addCargoUpgradeIntWorkbench(newStack, (LargeUpgrade)upgradeType.instanceSupplier.apply(cargoPlaneEntity));
                        } else {
                            PayloadEntry payloadEntry = PlanePayloadReloadListener.payloadEntries.get(newStack.m_41720_());
                            if (payloadEntry != null) {
                                cargoPlaneEntity.addCargoUpgradeIntWorkbench(newStack, new PayloadUpgrade(this.planeEntity, payloadEntry));
                            }
                        }
                    }
                }
            }
        }
    }

    private void tryUpgradeFromItem(ItemStack newStack, AtomicBoolean success) {
        PlaneEntity planeEntity;
        Item item = newStack.m_41720_();
        UpgradeType upgradeType = SimplePlanesUpgrades.ITEM_UPGRADE_MAP.get(item);
        PayloadEntry payloadEntry = null;
        if (upgradeType == null && (planeEntity = this.planeEntity) instanceof LargePlaneEntity) {
            LargePlaneEntity largePlaneEntity = (LargePlaneEntity)planeEntity;
            if (!largePlaneEntity.hasLargeUpgrade && (upgradeType = SimplePlanesUpgrades.LARGE_ITEM_UPGRADE_MAP.get(item)) == null && (payloadEntry = PlanePayloadReloadListener.payloadEntries.get(item)) != null) {
                upgradeType = (UpgradeType)SimplePlanesUpgrades.PAYLOAD.get();
            }
        }
        if (upgradeType != null && this.planeEntity.canAddUpgrade(upgradeType)) {
            if (payloadEntry != null && !(this.planeEntity instanceof CargoPlaneEntity)) {
                this.planeEntity.addUpgradeInWorkbench(newStack, new PayloadUpgrade(this.planeEntity, payloadEntry));
                success.set(true);
            } else {
                Upgrade upgrade = upgradeType.instanceSupplier.apply(this.planeEntity);
                if (!(this.planeEntity instanceof CargoPlaneEntity) || !(upgrade instanceof LargeUpgrade)) {
                    this.planeEntity.addUpgradeInWorkbench(newStack, upgrade);
                    success.set(true);
                }
            }
        }
    }

    public void m_6877_(Player player) {
        block7: {
            super.m_6877_(player);
            if (!(player instanceof ServerPlayer)) break block7;
            ServerPlayer serverPlayer = (ServerPlayer)player;
            HashSet<Item> attachedUpgradeItems = new HashSet<Item>(6);
            ArrayList<ItemStack> notAttachedItemStacks = new ArrayList<ItemStack>(6);
            for (Upgrade upgrade : this.planeEntity.upgrades.values()) {
                attachedUpgradeItems.add(upgrade.getItemStack().m_41720_());
            }
            for (int i = 0; i < 6; ++i) {
                ItemStack itemStack = this.itemHandler.getStackInSlot(i);
                if (itemStack.m_41619_()) continue;
                if (attachedUpgradeItems.contains(itemStack.m_41720_())) {
                    attachedUpgradeItems.remove(itemStack.m_41720_());
                    continue;
                }
                notAttachedItemStacks.add(itemStack);
            }
            if (serverPlayer.m_6084_() && !serverPlayer.m_9232_()) {
                for (ItemStack itemStack : notAttachedItemStacks) {
                    serverPlayer.m_150109_().m_150079_(itemStack);
                }
            } else {
                for (ItemStack itemStack : notAttachedItemStacks) {
                    serverPlayer.m_36176_(itemStack, false);
                }
            }
        }
    }

    public ItemStack m_7648_(Player player, int index) {
        return ItemStack.f_41583_;
    }

    public boolean m_6875_(Player playerIn) {
        return this.planeEntity != null && this.planeEntity.m_6084_();
    }

    private class MyItemStackHandler
    extends ItemStackHandler {
        public MyItemStackHandler() {
            super(14);
        }

        public void setStackInSlot(int slot, @NotNull ItemStack stack) {
            this.validateSlotIndex(slot);
            ItemStack previousStack = ((ItemStack)this.stacks.get(slot)).m_41777_();
            ItemStack newStack = stack.m_41777_();
            this.stacks.set(slot, (Object)stack);
            ModifyUpgradesContainer.this.itemsChanged(previousStack, newStack, slot);
            this.onContentsChanged(slot);
        }

        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (simulate) {
                return super.extractItem(slot, amount, simulate);
            }
            ItemStack previousStack = ((ItemStack)this.stacks.get(slot)).m_41777_();
            ItemStack result = super.extractItem(slot, amount, simulate);
            ItemStack newStack = (ItemStack)this.stacks.get(slot);
            ModifyUpgradesContainer.this.itemsChanged(previousStack, newStack, slot);
            return result;
        }

        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            if (simulate) {
                return super.insertItem(slot, stack, simulate);
            }
            ItemStack previousStack = ((ItemStack)this.stacks.get(slot)).m_41777_();
            ItemStack result = super.insertItem(slot, stack, simulate);
            ItemStack newStack = (ItemStack)this.stacks.get(slot);
            ModifyUpgradesContainer.this.itemsChanged(previousStack, newStack, slot);
            return result;
        }

        public int getSlotLimit(int slot) {
            return 1;
        }

        public void removeAndShift(int slot) {
            while (slot < this.stacks.size() - 1) {
                this.stacks.set(slot, (Object)((ItemStack)this.stacks.get(slot + 1)));
                ++slot;
            }
            this.stacks.set(this.stacks.size() - 1, (Object)ItemStack.f_41583_);
        }
    }
}

