/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.container;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.minecraftforge.registries.ForgeRegistries;
import xyz.przemyk.simpleplanes.container.PlaneCraftingResultSlot;
import xyz.przemyk.simpleplanes.network.CycleItemsPacket;
import xyz.przemyk.simpleplanes.recipes.PlaneWorkbenchRecipe;
import xyz.przemyk.simpleplanes.setup.SimplePlanesBlocks;
import xyz.przemyk.simpleplanes.setup.SimplePlanesContainers;
import xyz.przemyk.simpleplanes.setup.SimplePlanesRecipes;

public class PlaneWorkbenchContainer
extends AbstractContainerMenu {
    public static final ResourceLocation PLANE_MATERIALS = new ResourceLocation("simpleplanes", "plane_materials");
    public static final TagKey<Block> PLANE_MATERIALS_TAG = BlockTags.create((ResourceLocation)PLANE_MATERIALS);
    private final ItemStackHandler itemHandler;
    private final ItemStackHandler resultItemHandler = new ItemStackHandler();
    private final ContainerLevelAccess usabilityTest;
    private final Player player;
    private final DataSlot selectedRecipe;
    private final CompoundTag resultItemTag = new CompoundTag();
    private final List<PlaneWorkbenchRecipe> recipeList;

    public PlaneWorkbenchContainer(int id, Inventory playerInventory) {
        this(id, playerInventory, BlockPos.f_121853_, new ItemStackHandler(2), DataSlot.m_39401_());
    }

    public PlaneWorkbenchContainer(int id, Inventory playerInventory, BlockPos blockPos, ItemStackHandler itemHandler, DataSlot selectedRecipe) {
        super((MenuType)SimplePlanesContainers.PLANE_WORKBENCH.get(), id);
        this.player = playerInventory.f_35978_;
        this.itemHandler = itemHandler;
        this.usabilityTest = ContainerLevelAccess.m_39289_((Level)this.player.m_9236_(), (BlockPos)blockPos);
        this.recipeList = this.player.m_9236_().m_7465_().m_44013_((RecipeType)SimplePlanesRecipes.PLANE_WORKBENCH_RECIPE_TYPE.get());
        this.selectedRecipe = selectedRecipe;
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)itemHandler, 0, 28, 47));
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)itemHandler, 1, 75, 47));
        this.m_38897_((Slot)new PlaneCraftingResultSlot(this.player, this, (IItemHandler)this.resultItemHandler, 0, 134, 47));
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.m_38897_(new Slot((Container)playerInventory, k, 8 + k * 18, 142));
        }
        this.m_38895_(selectedRecipe);
        this.updateCraftingResult();
    }

    public void cycleItems(CycleItemsPacket.Type type) {
        int prevSelectedRecipe = this.selectedRecipe.m_6501_();
        ItemStack ingredient = this.itemHandler.getStackInSlot(0);
        ItemStack material = this.itemHandler.getStackInSlot(1);
        switch (type) {
            case CRAFTING_LEFT: {
                do {
                    if (this.selectedRecipe.m_6501_() == 0) {
                        this.selectedRecipe.m_6422_(this.recipeList.size() - 1);
                        continue;
                    }
                    this.selectedRecipe.m_6422_(this.selectedRecipe.m_6501_() - 1);
                } while (this.selectedRecipe.m_6501_() != prevSelectedRecipe && !this.recipeList.get(this.selectedRecipe.m_6501_()).canCraft(ingredient, material));
                break;
            }
            case CRAFTING_RIGHT: {
                do {
                    if (this.selectedRecipe.m_6501_() == this.recipeList.size() - 1) {
                        this.selectedRecipe.m_6422_(0);
                        continue;
                    }
                    this.selectedRecipe.m_6422_(this.selectedRecipe.m_6501_() + 1);
                } while (this.selectedRecipe.m_6501_() != prevSelectedRecipe && !this.recipeList.get(this.selectedRecipe.m_6501_()).canCraft(ingredient, material));
            }
        }
        this.updateCraftingResult();
    }

    public void onCrafting() {
        if (!this.player.m_9236_().f_46443_) {
            PlaneWorkbenchRecipe recipe = this.recipeList.get(this.selectedRecipe.m_6501_());
            this.itemHandler.extractItem(0, recipe.ingredientAmount(), false);
            this.itemHandler.extractItem(1, recipe.materialAmount(), false);
            this.updateCraftingResult();
        }
    }

    protected void updateCraftingResult() {
        if (!this.player.m_9236_().f_46443_) {
            BlockItem blockItem;
            ServerPlayer serverPlayerEntity = (ServerPlayer)this.player;
            ItemStack result = ItemStack.f_41583_;
            ItemStack ingredientStack = this.itemHandler.getStackInSlot(0);
            ItemStack materialStack = this.itemHandler.getStackInSlot(1);
            Item materialItem = materialStack.m_41720_();
            PlaneWorkbenchRecipe recipe = this.recipeList.get(this.selectedRecipe.m_6501_());
            if (recipe.canCraft(ingredientStack, materialStack) && materialItem instanceof BlockItem && (blockItem = (BlockItem)materialItem).m_40614_().m_204297_().m_203656_(PLANE_MATERIALS_TAG)) {
                result = recipe.result().m_41777_();
                Block block = blockItem.m_40614_();
                this.resultItemTag.m_128359_("material", ForgeRegistries.BLOCKS.getKey((Object)block).toString());
                result.m_41700_("EntityTag", (Tag)this.resultItemTag);
            }
            this.resultItemHandler.setStackInSlot(0, result);
            serverPlayerEntity.f_8906_.m_9829_((Packet)new ClientboundContainerSetSlotPacket(this.f_38840_, 0, 2, result));
        }
    }

    public boolean m_6875_(Player playerIn) {
        return PlaneWorkbenchContainer.m_38889_((ContainerLevelAccess)this.usabilityTest, (Player)playerIn, (Block)((Block)SimplePlanesBlocks.PLANE_WORKBENCH_BLOCK.get()));
    }

    public void m_150399_(int slotId, int dragType, ClickType clickTypeIn, Player player) {
        super.m_150399_(slotId, dragType, clickTypeIn, player);
        this.updateCraftingResult();
    }

    public ItemStack m_7648_(Player playerIn, int index) {
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack inputItemStack = slot.m_7993_();
            ItemStack originalItemStack = inputItemStack.m_41777_();
            if (index == 2) {
                inputItemStack.m_41720_().m_7836_(inputItemStack, playerIn.m_9236_(), playerIn);
                if (!this.m_38903_(inputItemStack, 3, 39, true)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(inputItemStack, originalItemStack);
            } else if (index >= 3 && index < 39 ? !this.m_38903_(inputItemStack, 0, 2, false) && (index < 30 ? !this.m_38903_(inputItemStack, 30, 39, false) : !this.m_38903_(inputItemStack, 3, 30, false)) : !this.m_38903_(inputItemStack, 3, 39, false)) {
                return ItemStack.f_41583_;
            }
            if (inputItemStack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (inputItemStack.m_41613_() == originalItemStack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(playerIn, inputItemStack);
            if (index == 2) {
                playerIn.m_36176_(inputItemStack, false);
            }
        }
        return ItemStack.f_41583_;
    }
}

