/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.addons.computercraft.peripheral;

import com.refinedmods.refinedstorage.api.autocrafting.task.CalculationResultType;
import com.refinedmods.refinedstorage.api.autocrafting.task.ICalculationResult;
import com.refinedmods.refinedstorage.api.autocrafting.task.ICraftingTask;
import com.refinedmods.refinedstorage.api.network.INetwork;
import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.api.peripheral.IComputerAccess;
import de.srendi.advancedperipherals.AdvancedPeripherals;
import de.srendi.advancedperipherals.common.addons.computercraft.owner.BlockEntityPeripheralOwner;
import de.srendi.advancedperipherals.common.addons.refinedstorage.RefinedStorage;
import de.srendi.advancedperipherals.common.addons.refinedstorage.RefinedStorageNode;
import de.srendi.advancedperipherals.common.addons.refinedstorage.RsFluidHandler;
import de.srendi.advancedperipherals.common.addons.refinedstorage.RsItemHandler;
import de.srendi.advancedperipherals.common.blocks.blockentities.RsBridgeEntity;
import de.srendi.advancedperipherals.common.configuration.APConfig;
import de.srendi.advancedperipherals.common.util.Pair;
import de.srendi.advancedperipherals.common.util.inventory.FluidFilter;
import de.srendi.advancedperipherals.common.util.inventory.FluidUtil;
import de.srendi.advancedperipherals.common.util.inventory.InventoryUtil;
import de.srendi.advancedperipherals.common.util.inventory.ItemFilter;
import de.srendi.advancedperipherals.common.util.inventory.ItemUtil;
import de.srendi.advancedperipherals.lib.peripherals.BasePeripheral;
import java.util.ArrayList;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RsBridgePeripheral
extends BasePeripheral<BlockEntityPeripheralOwner<RsBridgeEntity>> {
    public static final String PERIPHERAL_TYPE = "rsBridge";

    public RsBridgePeripheral(RsBridgeEntity tileEntity) {
        super(PERIPHERAL_TYPE, new BlockEntityPeripheralOwner<RsBridgeEntity>(tileEntity));
    }

    private RefinedStorageNode getNode() {
        return (RefinedStorageNode)((RsBridgeEntity)((BlockEntityPeripheralOwner)this.owner).tileEntity).getNode();
    }

    private INetwork getNetwork() {
        return this.getNode().getNetwork();
    }

    private MethodResult notConnected() {
        return MethodResult.of((Object[])new Object[]{null, "NOT_CONNECTED"});
    }

    @Override
    public boolean isEnabled() {
        return (Boolean)APConfig.PERIPHERALS_CONFIG.enableRSBridge.get();
    }

    @LuaFunction(mainThread=true)
    public final boolean isConnected() {
        return this.getNetwork() != null;
    }

    @LuaFunction(mainThread=true)
    public final MethodResult listItems() {
        if (!this.isConnected()) {
            return this.notConnected();
        }
        return MethodResult.of((Object)RefinedStorage.listItems(this.getNetwork()));
    }

    @LuaFunction(mainThread=true)
    public final MethodResult listCraftableItems() {
        if (!this.isConnected()) {
            return this.notConnected();
        }
        ArrayList items = new ArrayList();
        RefinedStorage.getCraftableItems(this.getNetwork()).forEach(item -> items.add(RefinedStorage.getObjectFromStack(item.m_41777_(), this.getNetwork())));
        return MethodResult.of(items);
    }

    @LuaFunction(mainThread=true)
    public final Object listCraftableFluids() {
        if (!this.isConnected()) {
            return this.notConnected();
        }
        ArrayList fluids = new ArrayList();
        RefinedStorage.getCraftableFluids(this.getNetwork()).forEach(fluid -> fluids.add(RefinedStorage.getObjectFromFluid(fluid, this.getNetwork())));
        return MethodResult.of(fluids);
    }

    @LuaFunction(mainThread=true)
    public final MethodResult getMaxItemDiskStorage() {
        if (!this.isConnected()) {
            return this.notConnected();
        }
        return MethodResult.of((Object)RefinedStorage.getMaxItemDiskStorage(this.getNetwork()));
    }

    @LuaFunction(mainThread=true)
    public final MethodResult getMaxFluidDiskStorage() {
        if (!this.isConnected()) {
            return this.notConnected();
        }
        return MethodResult.of((Object)RefinedStorage.getMaxFluidDiskStorage(this.getNetwork()));
    }

    @LuaFunction(mainThread=true)
    public final MethodResult getMaxItemExternalStorage() {
        if (!this.isConnected()) {
            return this.notConnected();
        }
        return MethodResult.of((Object)RefinedStorage.getMaxItemExternalStorage(this.getNetwork()));
    }

    @LuaFunction(mainThread=true)
    public final MethodResult getMaxFluidExternalStorage() {
        if (!this.isConnected()) {
            return this.notConnected();
        }
        return MethodResult.of((Object)RefinedStorage.getMaxFluidExternalStorage(this.getNetwork()));
    }

    @LuaFunction(mainThread=true)
    public final MethodResult listFluids() {
        if (!this.isConnected()) {
            return this.notConnected();
        }
        return MethodResult.of((Object)RefinedStorage.listFluids(this.getNetwork()));
    }

    @LuaFunction(mainThread=true)
    public final MethodResult getEnergyUsage() {
        if (!this.isConnected()) {
            return this.notConnected();
        }
        return MethodResult.of((Object)this.getNetwork().getEnergyUsage());
    }

    @LuaFunction(mainThread=true)
    public final MethodResult getMaxEnergyStorage() {
        if (!this.isConnected()) {
            return this.notConnected();
        }
        return MethodResult.of((Object)this.getNetwork().getEnergyStorage().getMaxEnergyStored());
    }

    @LuaFunction(mainThread=true)
    public final MethodResult getEnergyStorage() {
        if (!this.isConnected()) {
            return this.notConnected();
        }
        return MethodResult.of((Object)this.getNetwork().getEnergyStorage().getEnergyStored());
    }

    @LuaFunction(mainThread=true)
    public final MethodResult getPattern(IArguments arguments) throws LuaException {
        if (!this.isConnected()) {
            return this.notConnected();
        }
        Pair<ItemFilter, String> filter = ItemFilter.parse(arguments.getTable(0));
        if (filter.rightPresent()) {
            return MethodResult.of((Object[])new Object[]{false, filter.getRight()});
        }
        ItemFilter parsedFilter = filter.getLeft();
        if (parsedFilter.isEmpty()) {
            return MethodResult.of((Object[])new Object[]{false, "EMPTY_FILTER"});
        }
        ItemStack patternItem = RefinedStorage.findStackFromFilter(this.getNetwork(), this.getNetwork().getCraftingManager(), parsedFilter);
        return MethodResult.of((Object)RefinedStorage.getObjectFromPattern(this.getNetwork().getCraftingManager().getPattern(patternItem), this.getNetwork()));
    }

    protected MethodResult exportToChest(@NotNull IArguments arguments, @Nullable IItemHandler targetInventory) throws LuaException {
        RsItemHandler itemHandler = new RsItemHandler(this.getNetwork());
        if (targetInventory == null) {
            return MethodResult.of((Object[])new Object[]{0, "INVALID_TARGET"});
        }
        Pair<ItemFilter, String> filter = ItemFilter.parse(arguments.getTable(0));
        if (filter.rightPresent()) {
            return MethodResult.of((Object[])new Object[]{0, filter.getRight()});
        }
        return MethodResult.of((Object[])new Object[]{InventoryUtil.moveItem(itemHandler, targetInventory, filter.getLeft()), null});
    }

    protected MethodResult importToSystem(@NotNull IArguments arguments, @Nullable IItemHandler targetInventory) throws LuaException {
        RsItemHandler itemHandler = new RsItemHandler(this.getNetwork());
        if (targetInventory == null) {
            return MethodResult.of((Object[])new Object[]{0, "INVALID_TARGET"});
        }
        Pair<ItemFilter, String> filter = ItemFilter.parse(arguments.getTable(0));
        if (filter.rightPresent()) {
            return MethodResult.of((Object[])new Object[]{0, filter.getRight()});
        }
        return MethodResult.of((Object[])new Object[]{InventoryUtil.moveItem(targetInventory, itemHandler, filter.getLeft()), null});
    }

    protected MethodResult exportToTank(@NotNull IArguments arguments, @Nullable IFluidHandler targetInventory) throws LuaException {
        RsFluidHandler itemHandler = new RsFluidHandler(this.getNetwork());
        if (targetInventory == null) {
            return MethodResult.of((Object[])new Object[]{0, "INVALID_TARGET"});
        }
        Pair<FluidFilter, String> filter = FluidFilter.parse(arguments.getTable(0));
        if (filter.rightPresent()) {
            return MethodResult.of((Object[])new Object[]{0, filter.getRight()});
        }
        return MethodResult.of((Object[])new Object[]{InventoryUtil.moveFluid(itemHandler, targetInventory, filter.getLeft()), null});
    }

    protected MethodResult importToSystem(@NotNull IArguments arguments, @Nullable IFluidHandler targetInventory) throws LuaException {
        RsFluidHandler itemHandler = new RsFluidHandler(this.getNetwork());
        if (targetInventory == null) {
            return MethodResult.of((Object[])new Object[]{0, "INVALID_TARGET"});
        }
        Pair<FluidFilter, String> filter = FluidFilter.parse(arguments.getTable(0));
        if (filter.rightPresent()) {
            return MethodResult.of((Object[])new Object[]{0, filter.getRight()});
        }
        return MethodResult.of((Object[])new Object[]{InventoryUtil.moveFluid(targetInventory, itemHandler, filter.getLeft()), null});
    }

    @LuaFunction(mainThread=true)
    public final MethodResult exportItem(@NotNull IArguments arguments) throws LuaException {
        if (!this.isConnected()) {
            return this.notConnected();
        }
        IItemHandler inventory = InventoryUtil.getHandlerFromDirection(arguments.getString(1), this.owner);
        return this.exportToChest(arguments, inventory);
    }

    @LuaFunction(mainThread=true)
    public final MethodResult exportItemToPeripheral(IComputerAccess computer, IArguments arguments) throws LuaException {
        if (!this.isConnected()) {
            return this.notConnected();
        }
        IItemHandler inventory = InventoryUtil.getHandlerFromName(computer, arguments.getString(1));
        return this.exportToChest(arguments, inventory);
    }

    @LuaFunction(mainThread=true)
    public final MethodResult importItem(IArguments arguments) throws LuaException {
        if (!this.isConnected()) {
            return this.notConnected();
        }
        IItemHandler inventory = InventoryUtil.getHandlerFromDirection(arguments.getString(1), this.owner);
        return this.importToSystem(arguments, inventory);
    }

    @LuaFunction(mainThread=true)
    public final MethodResult importItemFromPeripheral(IComputerAccess computer, IArguments arguments) throws LuaException {
        if (!this.isConnected()) {
            return this.notConnected();
        }
        IItemHandler inventory = InventoryUtil.getHandlerFromName(computer, arguments.getString(1));
        return this.importToSystem(arguments, inventory);
    }

    @LuaFunction(mainThread=true)
    public final MethodResult exportFluid(@NotNull IArguments arguments) throws LuaException {
        if (!this.isConnected()) {
            return this.notConnected();
        }
        IFluidHandler inventory = FluidUtil.getHandlerFromDirection(arguments.getString(1), this.owner);
        return this.exportToTank(arguments, inventory);
    }

    @LuaFunction(mainThread=true)
    public final MethodResult exportFluidToPeripheral(IComputerAccess computer, IArguments arguments) throws LuaException {
        if (!this.isConnected()) {
            return this.notConnected();
        }
        IFluidHandler inventory = FluidUtil.getHandlerFromName(computer, arguments.getString(1));
        return this.exportToTank(arguments, inventory);
    }

    @LuaFunction(mainThread=true)
    public final MethodResult importFluid(IArguments arguments) throws LuaException {
        if (!this.isConnected()) {
            return this.notConnected();
        }
        IFluidHandler inventory = FluidUtil.getHandlerFromDirection(arguments.getString(1), this.owner);
        return this.importToSystem(arguments, inventory);
    }

    @LuaFunction(mainThread=true)
    public final MethodResult importFluidFromPeripheral(IComputerAccess computer, IArguments arguments) throws LuaException {
        if (!this.isConnected()) {
            return this.notConnected();
        }
        IFluidHandler inventory = FluidUtil.getHandlerFromName(computer, arguments.getString(1));
        return this.importToSystem(arguments, inventory);
    }

    @LuaFunction(mainThread=true)
    public final MethodResult getItem(IArguments arguments) throws LuaException {
        if (!this.isConnected()) {
            return this.notConnected();
        }
        Pair<ItemFilter, String> filter = ItemFilter.parse(arguments.getTable(0));
        if (filter.rightPresent()) {
            return MethodResult.of((Object[])new Object[]{null, filter.getRight()});
        }
        return MethodResult.of(RefinedStorage.getObjectFromStack(RefinedStorage.findStackFromFilter(this.getNetwork(), this.getNetwork().getCraftingManager(), filter.getLeft()), this.getNetwork()));
    }

    @LuaFunction(mainThread=true)
    public final MethodResult craftItem(IArguments arguments) throws LuaException {
        if (!this.isConnected()) {
            return this.notConnected();
        }
        Pair<ItemFilter, String> filter = ItemFilter.parse(arguments.getTable(0));
        if (filter.rightPresent()) {
            return MethodResult.of((Object[])new Object[]{null, filter.getRight()});
        }
        ItemStack stack = RefinedStorage.findStackFromFilter(this.getNetwork(), this.getNetwork().getCraftingManager(), filter.getLeft());
        if (stack == null) {
            return MethodResult.of((Object[])new Object[]{null, "NOT_CRAFTABLE"});
        }
        ICalculationResult result = this.getNetwork().getCraftingManager().create(stack, filter.getLeft().getCount());
        CalculationResultType type = result.getType();
        if (type == CalculationResultType.OK) {
            this.getNetwork().getCraftingManager().start(result.getTask());
        }
        AdvancedPeripherals.debug("Crafting Result of '" + ItemUtil.getRegistryKey(stack).toString() + "':" + type);
        return MethodResult.of((Object)(type == CalculationResultType.OK ? 1 : 0));
    }

    @LuaFunction(mainThread=true)
    public final MethodResult craftFluid(IArguments arguments) throws LuaException {
        if (!this.isConnected()) {
            return this.notConnected();
        }
        Pair<FluidFilter, String> filter = FluidFilter.parse(arguments.getTable(0));
        if (filter.rightPresent()) {
            return MethodResult.of((Object[])new Object[]{null, filter.getRight()});
        }
        FluidStack stack = RefinedStorage.findFluidFromFilter(this.getNetwork(), this.getNetwork().getCraftingManager(), filter.getLeft());
        if (stack == null) {
            return MethodResult.of((Object[])new Object[]{null, "NOT_CRAFTABLE"});
        }
        ICalculationResult result = this.getNetwork().getCraftingManager().create(stack, filter.getLeft().getCount());
        this.getNetwork().getCraftingManager().getPatterns();
        CalculationResultType type = result.getType();
        if (type == CalculationResultType.OK) {
            this.getNetwork().getCraftingManager().start(result.getTask());
        }
        AdvancedPeripherals.debug("Crafting Result of '" + FluidUtil.getRegistryKey(stack).toString() + "':" + type);
        return MethodResult.of((Object)(type == CalculationResultType.OK ? 1 : 0));
    }

    @LuaFunction(mainThread=true)
    public final MethodResult isItemCrafting(IArguments arguments) throws LuaException {
        if (!this.isConnected()) {
            return this.notConnected();
        }
        Pair<ItemFilter, String> filter = ItemFilter.parse(arguments.getTable(0));
        if (filter.rightPresent()) {
            return MethodResult.of((Object[])new Object[]{null, filter.getRight()});
        }
        ItemStack stack = RefinedStorage.findStackFromFilter(this.getNetwork(), this.getNetwork().getCraftingManager(), filter.getLeft());
        if (stack == null) {
            return MethodResult.of((Object[])new Object[]{null, "NOT_CRAFTABLE"});
        }
        for (ICraftingTask task : this.getNetwork().getCraftingManager().getTasks()) {
            ItemStack taskStack = task.getRequested().getItem();
            if (taskStack == null || !taskStack.m_150930_(stack.m_41720_())) continue;
            return MethodResult.of((Object)true);
        }
        return MethodResult.of((Object)false);
    }

    @LuaFunction(mainThread=true)
    public final MethodResult isItemCraftable(IArguments arguments) throws LuaException {
        if (!this.isConnected()) {
            return this.notConnected();
        }
        Pair<ItemFilter, String> filter = ItemFilter.parse(arguments.getTable(0));
        if (filter.rightPresent()) {
            return MethodResult.of((Object[])new Object[]{false, filter.getRight()});
        }
        ItemFilter parsedFilter = filter.getLeft();
        if (parsedFilter.isEmpty()) {
            return MethodResult.of((Object[])new Object[]{false, "EMPTY_FILTER"});
        }
        return MethodResult.of((Object)RefinedStorage.isItemCraftable(this.getNetwork(), parsedFilter.toItemStack()));
    }
}

