/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.addons.computercraft.peripheral.plugins;

import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.core.apis.TableHelper;
import de.srendi.advancedperipherals.common.addons.computercraft.owner.TurtlePeripheralOwner;
import de.srendi.advancedperipherals.common.addons.computercraft.peripheral.plugins.AutomataCorePlugin;
import de.srendi.advancedperipherals.common.util.LuaConverter;
import de.srendi.advancedperipherals.common.util.fakeplayer.APFakePlayer;
import de.srendi.advancedperipherals.lib.peripherals.AutomataCorePeripheral;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class AutomataLookPlugin
extends AutomataCorePlugin {
    public AutomataLookPlugin(AutomataCorePeripheral automataCore) {
        super(automataCore);
    }

    @LuaFunction(mainThread=true)
    public final MethodResult lookAtBlock(@NotNull IArguments arguments) throws LuaException {
        Map opts = arguments.count() > 0 ? arguments.getTable(0) : Collections.emptyMap();
        float yaw = opts != null ? (float)TableHelper.optNumberField((Map)opts, (String)"yaw", (double)0.0) : 0.0f;
        float pitch = opts != null ? (float)TableHelper.optNumberField((Map)opts, (String)"pitch", (double)0.0) : 0.0f;
        this.automataCore.addRotationCycle();
        TurtlePeripheralOwner owner = (TurtlePeripheralOwner)this.automataCore.getPeripheralOwner();
        HitResult result = owner.withPlayer(APFakePlayer.wrapActionWithRot(yaw, pitch, p -> p.findHit(true, false)));
        if (result.m_6662_() == HitResult.Type.MISS) {
            return MethodResult.of((Object[])new Object[]{null, "No block find"});
        }
        BlockHitResult blockHit = (BlockHitResult)result;
        BlockState state = owner.getLevel().m_8055_(blockHit.m_82425_());
        HashMap<String, Object> data = new HashMap<String, Object>();
        ResourceLocation blockName = ForgeRegistries.BLOCKS.getKey((Object)state.m_60734_());
        if (blockName != null) {
            data.put("name", blockName.toString());
        }
        data.put("tags", LuaConverter.tagsToList(() -> state.m_60734_().m_204297_().m_203616_()));
        return MethodResult.of(data);
    }

    @LuaFunction(mainThread=true)
    public final MethodResult lookAtEntity(@NotNull IArguments arguments) throws LuaException {
        Map opts = arguments.count() > 0 ? arguments.getTable(0) : Collections.emptyMap();
        float yaw = opts != null ? (float)TableHelper.optNumberField((Map)opts, (String)"yaw", (double)0.0) : 0.0f;
        float pitch = opts != null ? (float)TableHelper.optNumberField((Map)opts, (String)"pitch", (double)0.0) : 0.0f;
        this.automataCore.addRotationCycle();
        HitResult result = ((TurtlePeripheralOwner)this.automataCore.getPeripheralOwner()).withPlayer(APFakePlayer.wrapActionWithRot(yaw, pitch, p -> p.findHit(false, true)));
        if (result.m_6662_() == HitResult.Type.MISS) {
            return MethodResult.of((Object[])new Object[]{null, "No entity find"});
        }
        EntityHitResult entityHit = (EntityHitResult)result;
        return MethodResult.of(LuaConverter.entityToLua(entityHit.m_82443_()));
    }
}

