/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.util;

import de.srendi.advancedperipherals.AdvancedPeripherals;
import de.srendi.advancedperipherals.common.configuration.APConfig;
import de.srendi.advancedperipherals.common.util.NBTUtil;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.common.world.ForgeChunkManager;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.apache.logging.log4j.Level;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber(modid="advancedperipherals")
public class ChunkManager
extends SavedData {
    private static final String DATA_NAME = "advancedperipherals_ForcedChunks";
    private static final String FORCED_CHUNKS_TAG = "forcedChunks";
    private static int tickCounter = 0;
    private final Map<UUID, LoadChunkRecord> forcedChunks = new HashMap<UUID, LoadChunkRecord>();
    private boolean initialized = false;

    @NotNull
    public static ChunkManager get(@NotNull ServerLevel level) {
        return (ChunkManager)level.m_8895_().m_164861_(ChunkManager::load, ChunkManager::new, DATA_NAME);
    }

    public static ChunkManager load(@NotNull CompoundTag data) {
        ChunkManager manager = new ChunkManager();
        CompoundTag forcedData = data.m_128469_(FORCED_CHUNKS_TAG);
        AdvancedPeripherals.debug("Loading chunk manager from NBT " + data, Level.WARN);
        for (String key : forcedData.m_128431_()) {
            manager.forcedChunks.put(UUID.fromString(key), LoadChunkRecord.deserialize(forcedData.m_128469_(key)));
        }
        return manager;
    }

    @SubscribeEvent
    public static void afterServerStarted(ServerStartedEvent event) {
        ChunkManager.get(event.getServer().m_129783_()).init();
    }

    @SubscribeEvent
    public static void serverTick(TickEvent.ServerTickEvent event) {
        int checkIntervalInTick;
        if (event.phase == TickEvent.Phase.END && ++tickCounter >= (checkIntervalInTick = (Integer)APConfig.PERIPHERALS_CONFIG.chunkLoadValidTime.get() * 20 / 10)) {
            tickCounter = 0;
            ChunkManager.get(ServerLifecycleHooks.getCurrentServer().m_129783_()).cleanup();
        }
    }

    private static boolean forceChunk(UUID owner, ServerLevel level, ChunkPos pos) {
        AdvancedPeripherals.debug("Forcing chunk " + pos, Level.WARN);
        return ForgeChunkManager.forceChunk((ServerLevel)level, (String)"advancedperipherals", (UUID)owner, (int)pos.f_45578_, (int)pos.f_45579_, (boolean)true, (boolean)true);
    }

    private static boolean unforceChunk(UUID owner, ServerLevel level, ChunkPos pos) {
        AdvancedPeripherals.debug("Unforcing chunk " + pos, Level.WARN);
        return ForgeChunkManager.forceChunk((ServerLevel)level, (String)"advancedperipherals", (UUID)owner, (int)pos.f_45578_, (int)pos.f_45579_, (boolean)false, (boolean)true);
    }

    public synchronized boolean addForceChunk(ServerLevel level, UUID owner, ChunkPos pos) {
        AdvancedPeripherals.debug("Trying to load forced chunk cluster " + pos, Level.WARN);
        LoadChunkRecord oldRecord = this.forcedChunks.get(owner);
        if (oldRecord != null) {
            ServerLevel oldLevel = ChunkManager.getServerLevel(oldRecord.getDimensionName());
            if (oldLevel == level && pos.equals((Object)oldRecord.getPos())) {
                return true;
            }
            this.unforceChunkRecord(owner, oldRecord, oldLevel);
        }
        int chunkRadius = (Integer)APConfig.PERIPHERALS_CONFIG.chunkyTurtleRadius.get();
        this.forcedChunks.put(owner, new LoadChunkRecord(level.m_46472_().m_135782_().toString(), pos, chunkRadius));
        this.m_77762_();
        boolean result = true;
        for (int x = -chunkRadius; x <= chunkRadius; ++x) {
            for (int z = -chunkRadius; z <= chunkRadius; ++z) {
                result &= ChunkManager.forceChunk(owner, level, new ChunkPos(pos.f_45578_ + x, pos.f_45579_ + z));
            }
        }
        return result;
    }

    public synchronized void touch(UUID owner) {
        LoadChunkRecord forcedChunk = this.forcedChunks.get(owner);
        if (forcedChunk != null) {
            forcedChunk.touch();
        }
    }

    @Deprecated(forRemoval=true, since="1.20.1-0.7.39")
    public synchronized boolean removeForceChunk(ServerLevel level, UUID owner, ChunkPos pos) {
        return this.removeForceChunk(level, owner);
    }

    public synchronized boolean removeForceChunk(ServerLevel level, UUID owner) {
        AdvancedPeripherals.debug("Attempting to unload forced chunk cluster " + owner, Level.WARN);
        LoadChunkRecord chunkRecord = this.forcedChunks.get(owner);
        if (chunkRecord == null) {
            return true;
        }
        String dimensionName = level.m_46472_().m_135782_().toString();
        if (!chunkRecord.getDimensionName().equals(dimensionName)) {
            throw new IllegalArgumentException(String.format("Incorrect dimension! Should be %s instead of %s", chunkRecord.getDimensionName(), dimensionName));
        }
        boolean result = this.unforceChunkRecord(owner, chunkRecord, level);
        if (result) {
            this.forcedChunks.remove(owner);
            this.m_77762_();
        }
        return result;
    }

    private synchronized boolean unforceChunkRecord(UUID owner, LoadChunkRecord chunkRecord, ServerLevel level) {
        boolean result = true;
        ChunkPos pos = chunkRecord.getPos();
        int chunkRadius = chunkRecord.getRadius();
        AdvancedPeripherals.debug(String.format("Trying to unload forced chunk cluster %s at %s with radius %d", owner, pos, chunkRadius), Level.WARN);
        for (int x = -chunkRadius; x <= chunkRadius; ++x) {
            for (int z = -chunkRadius; z <= chunkRadius; ++z) {
                result &= ChunkManager.unforceChunk(owner, level, new ChunkPos(pos.f_45578_ + x, pos.f_45579_ + z));
            }
        }
        return result;
    }

    public synchronized void init() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        AdvancedPeripherals.debug(String.format("Schedule chunk manager init, forcedChunks = %d", this.forcedChunks.size()), Level.WARN);
        int chunkRadius = (Integer)APConfig.PERIPHERALS_CONFIG.chunkyTurtleRadius.get();
        Map<String, ServerLevel> levels = ChunkManager.getServerLevels();
        this.forcedChunks.forEach((uuid, value) -> {
            String dimensionName = value.getDimensionName();
            ServerLevel level = (ServerLevel)levels.get(dimensionName);
            if (level == null) {
                AdvancedPeripherals.debug("Skipped not exists dimension " + dimensionName, Level.ERROR);
                return;
            }
            ChunkPos pos = value.getPos();
            int loadedRadius = value.getRadius();
            AdvancedPeripherals.debug(String.format("Recorded chunk in %s at %s with radius %d", dimensionName, pos, loadedRadius), Level.INFO);
            if (loadedRadius == chunkRadius) {
                return;
            }
            if (loadedRadius == -1) {
                for (int x = -chunkRadius; x <= chunkRadius; ++x) {
                    for (int z = -chunkRadius; z <= chunkRadius; ++z) {
                        ChunkManager.forceChunk(uuid, level, new ChunkPos(pos.f_45578_ + x, pos.f_45579_ + z));
                    }
                }
            } else if (loadedRadius > chunkRadius) {
                for (int x = -loadedRadius; x <= loadedRadius; ++x) {
                    for (int z = -loadedRadius; z <= loadedRadius; ++z) {
                        if (Math.abs(x) <= chunkRadius && Math.abs(z) <= chunkRadius) continue;
                        ChunkManager.unforceChunk(uuid, level, new ChunkPos(pos.f_45578_ + x, pos.f_45579_ + z));
                    }
                }
            } else if (loadedRadius < chunkRadius) {
                for (int x = -chunkRadius; x <= chunkRadius; ++x) {
                    for (int z = -chunkRadius; z <= chunkRadius; ++z) {
                        if (Math.abs(x) <= loadedRadius && Math.abs(z) <= loadedRadius) continue;
                        ChunkManager.forceChunk(uuid, level, new ChunkPos(pos.f_45578_ + x, pos.f_45579_ + z));
                    }
                }
            }
            value.setRadius(chunkRadius);
            this.m_77762_();
        });
    }

    public synchronized void cleanup() {
        AdvancedPeripherals.debug("Schedule chunk manager cleanup", Level.WARN);
        Map<String, ServerLevel> levels = ChunkManager.getServerLevels();
        Iterator<Map.Entry<UUID, LoadChunkRecord>> iterator = this.forcedChunks.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<UUID, LoadChunkRecord> entry = iterator.next();
            UUID uuid = entry.getKey();
            LoadChunkRecord chunkRecord = entry.getValue();
            String dimensionName = chunkRecord.getDimensionName();
            ServerLevel level = levels.get(dimensionName);
            if (level == null || chunkRecord.isValid()) continue;
            AdvancedPeripherals.debug(String.format("Purge forced chunk for %s", uuid), Level.WARN);
            this.unforceChunkRecord(uuid, chunkRecord, level);
            iterator.remove();
            this.m_77762_();
        }
    }

    @NotNull
    public synchronized CompoundTag m_7176_(@NotNull CompoundTag data) {
        AdvancedPeripherals.debug("Schedule chunk manager save, forcedChunks = " + this.forcedChunks.size(), Level.WARN);
        CompoundTag forcedChunksTag = new CompoundTag();
        this.forcedChunks.forEach((key, value) -> forcedChunksTag.m_128365_(key.toString(), (Tag)value.serialize()));
        data.m_128365_(FORCED_CHUNKS_TAG, (Tag)forcedChunksTag);
        return data;
    }

    private static Map<String, ServerLevel> getServerLevels() {
        HashMap<String, ServerLevel> levels = new HashMap<String, ServerLevel>();
        ServerLifecycleHooks.getCurrentServer().m_129785_().forEach(level -> {
            String dimensionName = level.m_46472_().m_135782_().toString();
            levels.put(dimensionName, (ServerLevel)level);
        });
        return levels;
    }

    private static ServerLevel getServerLevel(String name) {
        ResourceKey key = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(name));
        return ServerLifecycleHooks.getCurrentServer().m_129880_(key);
    }

    private static class LoadChunkRecord {
        private static final String POS_TAG = "pos";
        private static final String DIMENSION_NAME_TAG = "dimensionName";
        private static final String RADIUS_TAG = "radius";
        @NotNull
        private final String dimensionName;
        @NotNull
        private final ChunkPos pos;
        private int radius;
        private long lastTouch;

        LoadChunkRecord(@NotNull String dimensionName, @NotNull ChunkPos pos, int radius) {
            this.dimensionName = dimensionName;
            this.pos = pos;
            this.radius = radius;
            this.lastTouch = LocalDateTime.now().toEpochSecond(ZoneOffset.UTC);
        }

        public static LoadChunkRecord deserialize(@NotNull CompoundTag tag) {
            Set keys = tag.m_128431_();
            int radius = keys.contains(RADIUS_TAG) ? tag.m_128451_(RADIUS_TAG) : -1;
            return new LoadChunkRecord(tag.m_128461_(DIMENSION_NAME_TAG), NBTUtil.chunkPosFromNBT(tag.m_128469_(POS_TAG)), radius);
        }

        @NotNull
        public ChunkPos getPos() {
            return this.pos;
        }

        @NotNull
        public String getDimensionName() {
            return this.dimensionName;
        }

        public int getRadius() {
            return this.radius;
        }

        public void setRadius(int radius) {
            this.radius = radius;
        }

        public void touch() {
            this.lastTouch = LocalDateTime.now().toEpochSecond(ZoneOffset.UTC);
        }

        public boolean isValid() {
            long currentEpoch = LocalDateTime.now().toEpochSecond(ZoneOffset.UTC);
            return this.lastTouch + (long)((Integer)APConfig.PERIPHERALS_CONFIG.chunkLoadValidTime.get()).intValue() >= currentEpoch;
        }

        @NotNull
        public CompoundTag serialize() {
            CompoundTag tag = new CompoundTag();
            tag.m_128359_(DIMENSION_NAME_TAG, this.dimensionName);
            tag.m_128365_(POS_TAG, (Tag)NBTUtil.toNBT(this.pos));
            tag.m_128405_(RADIUS_TAG, this.radius);
            return tag;
        }
    }
}

