/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.api.common.display.basic;

import dev.architectury.utils.EnvExecutor;
import dev.architectury.utils.GameInstance;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.display.SimpleDisplaySerializer;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public abstract class BasicDisplay
implements Display {
    protected static final Supplier<RegistryAccess> REGISTRY_ACCESS = (Supplier)EnvExecutor.getEnvSpecific(() -> () -> () -> GameInstance.getClient().f_91074_.m_9236_().m_9598_(), () -> () -> () -> GameInstance.getServer().m_206579_());
    protected List<EntryIngredient> inputs;
    protected List<EntryIngredient> outputs;
    protected Optional<ResourceLocation> location;

    public BasicDisplay(List<EntryIngredient> inputs, List<EntryIngredient> outputs) {
        this(inputs, outputs, Optional.empty());
    }

    public BasicDisplay(List<EntryIngredient> inputs, List<EntryIngredient> outputs, Optional<ResourceLocation> location) {
        this.inputs = inputs;
        this.outputs = outputs;
        this.location = location;
    }

    @ApiStatus.Experimental
    public static RegistryAccess registryAccess() {
        return REGISTRY_ACCESS.get();
    }

    @Override
    public List<EntryIngredient> getInputEntries() {
        return this.inputs;
    }

    @Override
    public List<EntryIngredient> getOutputEntries() {
        return this.outputs;
    }

    @Override
    public Optional<ResourceLocation> getDisplayLocation() {
        return this.location;
    }

    public static class Serializer<P extends BasicDisplay>
    implements SimpleDisplaySerializer<P> {
        protected final Constructor<P> constructor;
        protected final ExtraSerializer<P> extraSerializer;
        protected EntryIngredientsProvider<P> inputEntries = EntryIngredientsProvider.pass();
        protected EntryIngredientsProvider<P> outputEntries = EntryIngredientsProvider.pass();

        public static <P extends BasicDisplay> Serializer<P> ofSimple(SimpleConstructor<P> constructor) {
            return new Serializer<BasicDisplay>(constructor, (p, tag) -> {});
        }

        public static <P extends BasicDisplay> Serializer<P> ofRecipeLess(RecipeLessConstructor<P> constructor) {
            return new Serializer<BasicDisplay>(constructor, (p, tag) -> {});
        }

        public static <P extends BasicDisplay> Serializer<P> ofSimpleRecipeLess(SimpleRecipeLessConstructor<P> constructor) {
            return new Serializer<BasicDisplay>(constructor, (p, tag) -> {});
        }

        public static <P extends BasicDisplay> Serializer<P> of(Constructor<P> constructor) {
            return new Serializer<BasicDisplay>(constructor, (p, tag) -> {});
        }

        private Serializer(Constructor<P> constructor) {
            this(constructor, (p, tag) -> {});
        }

        public static <P extends BasicDisplay> Serializer<P> ofSimple(SimpleConstructor<P> constructor, ExtraSerializer<P> extraSerializer) {
            return new Serializer<P>(constructor, extraSerializer);
        }

        public static <P extends BasicDisplay> Serializer<P> ofRecipeLess(RecipeLessConstructor<P> constructor, ExtraSerializer<P> extraSerializer) {
            return new Serializer<P>(constructor, extraSerializer);
        }

        public static <P extends BasicDisplay> Serializer<P> ofSimpleRecipeLess(SimpleRecipeLessConstructor<P> constructor, ExtraSerializer<P> extraSerializer) {
            return new Serializer<P>(constructor, extraSerializer);
        }

        public static <P extends BasicDisplay> Serializer<P> of(Constructor<P> constructor, ExtraSerializer<P> extraSerializer) {
            return new Serializer<P>(constructor, extraSerializer);
        }

        protected Serializer(Constructor<P> constructor, ExtraSerializer<P> extraSerializer) {
            this.constructor = constructor;
            this.extraSerializer = extraSerializer;
        }

        public Serializer<P> inputProvider(EntryIngredientsProvider<P> provider) {
            this.inputEntries = provider;
            return this;
        }

        public Serializer<P> outputProvider(EntryIngredientsProvider<P> provider) {
            this.outputEntries = provider;
            return this;
        }

        @Override
        public CompoundTag saveExtra(CompoundTag tag, P display) {
            ((BasicDisplay)display).getDisplayLocation().ifPresent(location -> tag.m_128359_("location", location.toString()));
            this.extraSerializer.serialize(display, tag);
            return tag;
        }

        @Override
        public P read(CompoundTag tag) {
            List<EntryIngredient> input = EntryIngredients.read(tag.m_128437_("input", 9));
            List<EntryIngredient> output = EntryIngredients.read(tag.m_128437_("output", 9));
            ResourceLocation location = tag.m_128425_("location", 8) ? new ResourceLocation(tag.m_128461_("location")) : null;
            return (P)((BasicDisplay)this.constructor.construct(input, output, Optional.ofNullable(location), tag));
        }

        @Override
        public List<EntryIngredient> getInputIngredients(P display) {
            List<EntryIngredient> entries = this.inputEntries.getEntries(display);
            if (entries != null) {
                return entries;
            }
            return SimpleDisplaySerializer.super.getInputIngredients(display);
        }

        @Override
        public List<EntryIngredient> getOutputIngredients(P display) {
            List<EntryIngredient> entries = this.outputEntries.getEntries(display);
            if (entries != null) {
                return entries;
            }
            return SimpleDisplaySerializer.super.getOutputIngredients(display);
        }

        @FunctionalInterface
        public static interface ExtraSerializer<R extends Display> {
            public void serialize(R var1, CompoundTag var2);
        }

        @FunctionalInterface
        public static interface Constructor<R> {
            public R construct(List<EntryIngredient> var1, List<EntryIngredient> var2, Optional<ResourceLocation> var3, CompoundTag var4);
        }

        @FunctionalInterface
        public static interface EntryIngredientsProvider<R extends Display> {
            @Nullable
            public List<EntryIngredient> getEntries(R var1);

            public static <R extends Display> EntryIngredientsProvider<R> pass() {
                return display -> null;
            }
        }

        @FunctionalInterface
        public static interface SimpleRecipeLessConstructor<R extends Display>
        extends Constructor<R> {
            @Override
            default public R construct(List<EntryIngredient> input, List<EntryIngredient> output, Optional<ResourceLocation> location, CompoundTag tag) {
                return this.construct(input, output);
            }

            public R construct(List<EntryIngredient> var1, List<EntryIngredient> var2);
        }

        @FunctionalInterface
        public static interface RecipeLessConstructor<R extends Display>
        extends Constructor<R> {
            @Override
            default public R construct(List<EntryIngredient> input, List<EntryIngredient> output, Optional<ResourceLocation> location, CompoundTag tag) {
                return this.construct(input, output, tag);
            }

            public R construct(List<EntryIngredient> var1, List<EntryIngredient> var2, CompoundTag var3);
        }

        @FunctionalInterface
        public static interface SimpleConstructor<R extends Display>
        extends Constructor<R> {
            @Override
            default public R construct(List<EntryIngredient> input, List<EntryIngredient> output, Optional<ResourceLocation> location, CompoundTag tag) {
                return this.construct(input, output, location);
            }

            public R construct(List<EntryIngredient> var1, List<EntryIngredient> var2, Optional<ResourceLocation> var3);
        }
    }
}

