/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.api.common.entry;

import java.util.Collections;
import java.util.List;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.type.EntryType;
import me.shedaniel.rei.api.common.util.CollectionUtils;

public interface InputIngredient<T> {
    public static <T> InputIngredient<T> empty(int index) {
        return InputIngredient.of(index, Collections.emptyList());
    }

    public static <T> InputIngredient<T> of(final int index, final List<T> ingredient) {
        return new InputIngredient<T>(){

            @Override
            public List<T> get() {
                return ingredient;
            }

            @Override
            public int getIndex() {
                return index;
            }
        };
    }

    public static <T> InputIngredient<T> of(final int index, final int displayIndex, final List<T> ingredient) {
        return new InputIngredient<T>(){

            @Override
            public List<T> get() {
                return ingredient;
            }

            @Override
            public int getIndex() {
                return index;
            }

            @Override
            public int getDisplayIndex() {
                return displayIndex;
            }
        };
    }

    public static <T> InputIngredient<T> withType(final InputIngredient<EntryStack<?>> ingredient, final EntryType<T> type) {
        return new InputIngredient<T>(){
            List<T> list;
            {
                this.list = CollectionUtils.filterAndMap(ingredient.get(), stack -> stack.getType() == type, EntryStack::castValue);
            }

            @Override
            public List<T> get() {
                return this.list;
            }

            @Override
            public int getIndex() {
                return ingredient.getIndex();
            }

            @Override
            public int getDisplayIndex() {
                return ingredient.getDisplayIndex();
            }
        };
    }

    public List<T> get();

    public int getIndex();

    default public int getDisplayIndex() {
        return this.getIndex();
    }
}

