/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.search.argument.type;

import java.util.Locale;
import me.shedaniel.rei.api.client.ClientHelper;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.gui.config.SearchMode;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.impl.client.search.argument.type.ArgumentType;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.util.Unit;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
@ApiStatus.Internal
public final class ModArgumentType
extends ArgumentType<Unit, ModInfoPair> {
    public static final ModArgumentType INSTANCE = new ModArgumentType();
    private static final Style STYLE = Style.f_131099_.m_131148_(TextColor.m_131266_((int)16754931));

    @Override
    public String getName() {
        return "mod";
    }

    @Override
    @Nullable
    public String getPrefix() {
        return "@";
    }

    @Override
    public SearchMode getSearchMode() {
        return ConfigObject.getInstance().getModSearchMode();
    }

    @Override
    @Nullable
    public ModInfoPair cacheData(EntryStack<?> stack) {
        String containingNs = stack.getContainingNamespace();
        return containingNs != null ? new ModInfoPair(containingNs, null) : ModInfoPair.EMPTY;
    }

    @Override
    public void matches(@Nullable ModInfoPair pair, EntryStack<?> stack, Unit filterData, ArgumentType.ResultSink sink) {
        if (pair.modId == null || sink.testString(pair.modId)) {
            return;
        }
        if (pair.modName == null) {
            pair.modName = ClientHelper.getInstance().getModFromModId(pair.modId).toLowerCase(Locale.ROOT);
        }
        sink.testString(pair.modName);
    }

    @Override
    public Unit prepareSearchFilter(String searchText) {
        return Unit.INSTANCE;
    }

    @Override
    public Style getHighlightedStyle() {
        return STYLE;
    }

    protected static class ModInfoPair {
        private static final ModInfoPair EMPTY = new ModInfoPair(null, null);
        @Nullable
        private final String modId;
        @Nullable
        private String modName;

        public ModInfoPair(@Nullable String modId, @Nullable String modName) {
            this.modId = modId;
            this.modName = modName;
        }
    }
}

