/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.common.displays;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.basic.BasicDisplay;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.plugin.common.BuiltinPlugin;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.armortrim.ArmorTrim;
import net.minecraft.world.item.armortrim.TrimMaterials;
import net.minecraft.world.item.armortrim.TrimPatterns;
import net.minecraft.world.item.crafting.SmithingRecipe;
import net.minecraft.world.item.crafting.SmithingTransformRecipe;
import net.minecraft.world.item.crafting.SmithingTrimRecipe;
import org.jetbrains.annotations.ApiStatus;

public class DefaultSmithingDisplay
extends BasicDisplay {
    @ApiStatus.Experimental
    public DefaultSmithingDisplay(SmithingTransformRecipe recipe) {
        this((SmithingRecipe)recipe, List.of(EntryIngredients.ofIngredient(recipe.f_265949_), EntryIngredients.ofIngredient(recipe.f_265888_), EntryIngredients.ofIngredient(recipe.f_265907_)));
    }

    @Deprecated(forRemoval=true)
    public DefaultSmithingDisplay(SmithingTrimRecipe recipe) {
        this((SmithingRecipe)recipe, List.of(EntryIngredients.ofIngredient(recipe.f_265958_), EntryIngredients.ofIngredient(recipe.f_266040_), EntryIngredients.ofIngredient(recipe.f_266053_)));
    }

    @ApiStatus.Experimental
    public static List<DefaultSmithingDisplay> from(SmithingTrimRecipe recipe) {
        RegistryAccess registryAccess = BasicDisplay.registryAccess();
        ArrayList<DefaultSmithingDisplay> displays = new ArrayList<DefaultSmithingDisplay>();
        for (ItemStack templateItem : recipe.f_265958_.m_43908_()) {
            Holder.Reference trimPattern = TrimPatterns.m_266468_((RegistryAccess)registryAccess, (ItemStack)templateItem).orElse(null);
            if (trimPattern == null) continue;
            for (ItemStack additionStack : recipe.f_266053_.m_43908_()) {
                Holder.Reference trimMaterial = TrimMaterials.m_266539_((RegistryAccess)registryAccess, (ItemStack)additionStack).orElse(null);
                if (trimMaterial == null) continue;
                ArmorTrim armorTrim = new ArmorTrim((Holder)trimMaterial, (Holder)trimPattern);
                EntryIngredient.Builder baseItems = EntryIngredient.builder();
                EntryIngredient.Builder outputItems = EntryIngredient.builder();
                for (ItemStack item : recipe.f_266040_.m_43908_()) {
                    Optional trim = ArmorTrim.m_266285_((RegistryAccess)registryAccess, (ItemStack)item);
                    if (!trim.isEmpty() && ((ArmorTrim)trim.get()).m_266357_((Holder)trimPattern, (Holder)trimMaterial)) continue;
                    ItemStack newItem = item.m_41777_();
                    newItem.m_41764_(1);
                    if (!ArmorTrim.m_266570_((RegistryAccess)registryAccess, (ItemStack)newItem, (ArmorTrim)armorTrim)) continue;
                    baseItems.add((EntryStack<?>)EntryStacks.of(item.m_41777_()));
                    outputItems.add((EntryStack<?>)EntryStacks.of(newItem));
                }
                displays.add(new DefaultSmithingDisplay(List.of(EntryIngredients.of(templateItem), baseItems.build(), EntryIngredients.of(additionStack)), List.of(outputItems.build()), Optional.ofNullable(recipe.m_6423_())));
            }
        }
        return displays;
    }

    public DefaultSmithingDisplay(SmithingRecipe recipe, List<EntryIngredient> inputs) {
        this(inputs, List.of(EntryIngredients.of(recipe.m_8043_(BasicDisplay.registryAccess()))), Optional.ofNullable(recipe.m_6423_()));
    }

    public DefaultSmithingDisplay(List<EntryIngredient> inputs, List<EntryIngredient> outputs, Optional<ResourceLocation> location) {
        super(inputs, outputs, location);
    }

    @Override
    public CategoryIdentifier<?> getCategoryIdentifier() {
        return BuiltinPlugin.SMITHING;
    }

    public static BasicDisplay.Serializer<DefaultSmithingDisplay> serializer() {
        return BasicDisplay.Serializer.ofSimple(DefaultSmithingDisplay::new);
    }
}

