/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.category.ui;

import java.util.function.Supplier;
import javax.annotation.Nonnull;
import xaero.common.category.ObjectCategory;
import xaero.common.category.setting.ObjectCategorySetting;
import xaero.common.category.ui.data.GuiCategoryUIEditorCategoryData;
import xaero.common.category.ui.data.GuiCategoryUIEditorSettingsData;
import xaero.common.category.ui.data.options.range.setting.IGuiCategoryUIEditorSettingData;

public abstract class GuiCategoryUIEditorDataConverter<C extends ObjectCategory<?, C>, ED extends GuiCategoryUIEditorCategoryData<C, SD, ED>, CB extends ObjectCategory.Builder<C, CB>, SD extends GuiCategoryUIEditorSettingsData<?>, SDB extends GuiCategoryUIEditorSettingsData.Builder<SD, SDB>, EDB extends GuiCategoryUIEditorCategoryData.Builder<C, ED, SD, SDB, EDB>> {
    private final Supplier<CB> categoryBuilderFactory;
    private final Supplier<EDB> editorDataBuilderFactory;

    public GuiCategoryUIEditorDataConverter(@Nonnull Supplier<CB> categoryBuilderFactory, @Nonnull Supplier<EDB> editorDataBuilderFactory) {
        this.categoryBuilderFactory = categoryBuilderFactory;
        this.editorDataBuilderFactory = editorDataBuilderFactory;
    }

    public ED convert(C category, boolean canBeRoot) {
        return (ED)((GuiCategoryUIEditorCategoryData.Builder)this.getConfiguredBuilder(category, canBeRoot)).build();
    }

    protected EDB getConfiguredBuilder(C category, boolean canBeRoot) {
        GuiCategoryUIEditorCategoryData.Builder editorDataBuilder = (GuiCategoryUIEditorCategoryData.Builder)this.editorDataBuilderFactory.get();
        editorDataBuilder.setName(((ObjectCategory)category).getName());
        Object settingDataBuilder = editorDataBuilder.getSettingDataBuilder();
        ((ObjectCategory)category).getSettingOverridesIterator().forEachRemaining(e -> this.setSettingValue((CB)settingDataBuilder, (ObjectCategorySetting<T>)((ObjectCategorySetting)e.getKey()), e.getValue()));
        ((GuiCategoryUIEditorSettingsData.Builder)settingDataBuilder).setRootSettings(canBeRoot && ((ObjectCategory)category).getSuperCategory() == null);
        ((GuiCategoryUIEditorSettingsData.Builder)settingDataBuilder).setProtection(((ObjectCategory)category).getProtection());
        ((ObjectCategory)category).getDirectSubCategoryIterator().forEachRemaining(sc -> editorDataBuilder.addSubCategoryBuilder(this.getConfiguredBuilder(sc, canBeRoot)));
        return (EDB)editorDataBuilder;
    }

    private <T> void setSettingValue(SDB settingOverridesBuilder, ObjectCategorySetting<T> setting, Object value) {
        ((GuiCategoryUIEditorSettingsData.Builder)settingOverridesBuilder).setSettingValue(setting, (Object)value);
    }

    public C convert(ED editorData) {
        return ((ObjectCategory.Builder)this.getConfiguredBuilder(editorData)).build();
    }

    protected CB getConfiguredBuilder(ED editorData) {
        ObjectCategory.Builder categoryBuilder = (ObjectCategory.Builder)this.categoryBuilderFactory.get();
        categoryBuilder.setName(((GuiCategoryUIEditorCategoryData)editorData).getName());
        categoryBuilder.setProtection(((GuiCategoryUIEditorSettingsData)((GuiCategoryUIEditorCategoryData)editorData).getSettingsData()).getProtection());
        ((GuiCategoryUIEditorSettingsData)((GuiCategoryUIEditorCategoryData)editorData).getSettingsData()).getSettings().forEach((k, d) -> this.setSettingValue((CB)categoryBuilder, (ObjectCategorySetting<T>)((ObjectCategorySetting)k), ((IGuiCategoryUIEditorSettingData)((Object)d)).getSettingValue()));
        ((GuiCategoryUIEditorCategoryData)editorData).getSubCategories().forEach(sed -> categoryBuilder.addSubCategoryBuilder(this.getConfiguredBuilder(sed)));
        return (CB)categoryBuilder;
    }

    private <T> void setSettingValue(CB categoryBuilder, ObjectCategorySetting<T> setting, Object value) {
        ((ObjectCategory.Builder)categoryBuilder).setSettingValue(setting, (Object)value);
    }

    public static abstract class Builder<C extends ObjectCategory<?, C>, ED extends GuiCategoryUIEditorCategoryData<C, SD, ED>, CB extends ObjectCategory.Builder<C, CB>, SD extends GuiCategoryUIEditorSettingsData<?>, SDB extends GuiCategoryUIEditorSettingsData.Builder<SD, SDB>, EDB extends GuiCategoryUIEditorCategoryData.Builder<C, ED, SD, SDB, EDB>, B extends Builder<C, ED, CB, SD, SDB, EDB, B>> {
        protected final B self = this;
        protected final Supplier<CB> categoryBuilderFactory;
        protected final Supplier<EDB> editorDataBuilderFactory;

        protected Builder(Supplier<CB> categoryBuilderFactory, Supplier<EDB> editorDataBuilderFactory) {
            this.categoryBuilderFactory = categoryBuilderFactory;
            this.editorDataBuilderFactory = editorDataBuilderFactory;
        }

        protected B setDefault() {
            return this.self;
        }

        public GuiCategoryUIEditorDataConverter<C, ED, CB, SD, SDB, EDB> build() {
            return this.buildInternally();
        }

        protected abstract GuiCategoryUIEditorDataConverter<C, ED, CB, SD, SDB, EDB> buildInternally();
    }
}

