/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.render.radar.variant;

import java.lang.reflect.Method;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import xaero.common.minimap.render.radar.EntityIconDefinitions;
import xaero.common.minimap.render.radar.resource.EntityIconDefinition;
import xaero.hud.minimap.MinimapLogs;

public class EntityIconVariantHandler {
    private final StringBuilder legacyEntityStringBuilder = new StringBuilder();

    public <T extends Entity> Object getEntityVariant(EntityIconDefinition iconDefinition, T entity, EntityRenderer<? super T> entityRenderer) {
        Object variant = null;
        ResourceLocation entityTexture = null;
        try {
            ResourceLocation entityTextureUnchecked;
            entityTexture = entityTextureUnchecked = entityRenderer.m_5478_(entity);
        }
        catch (Throwable e) {
            MinimapLogs.LOGGER.error("Exception while fetching entity texture to build its variant ID for " + EntityType.m_20613_((EntityType)entity.m_6095_()));
            MinimapLogs.LOGGER.error("The exception is most likely on another mod's end and suppressing it here could lead to more issues. Please report to appropriate mod devs.", e);
        }
        if (iconDefinition != null) {
            Method variantMethod = iconDefinition.getVariantMethod();
            if (variantMethod != null) {
                try {
                    variantMethod.invoke(null, entityTexture, entityRenderer, entity);
                }
                catch (Throwable e) {
                    ResourceLocation entityId = EntityType.m_20613_((EntityType)entity.m_6095_());
                    MinimapLogs.LOGGER.error("Exception while using the variant ID method " + iconDefinition.getVariantMethodString() + " defined for " + entityId);
                    MinimapLogs.LOGGER.error("If the exception is on another mod's end, suppressing it here could lead to more issues. Please report to appropriate mod devs.", e);
                    iconDefinition.setVariantMethod(null);
                }
            } else {
                variant = this.getLegacyVariantId(iconDefinition, entity, entityRenderer);
            }
        }
        if (variant == null) {
            variant = EntityIconDefinitions.getVariant(entityTexture, entityRenderer, entity);
        }
        return variant;
    }

    private <T extends Entity> String getLegacyVariantId(EntityIconDefinition iconDefinition, T entity, EntityRenderer<? super T> entityRenderer) {
        boolean variantIdAppended = false;
        Method variantIdBuilderMethod = iconDefinition.getVariantIdBuilderMethod();
        if (variantIdBuilderMethod != null && !variantIdBuilderMethod.equals(EntityIconDefinitions.BUILD_VARIANT_ID_STRING_METHOD)) {
            this.legacyEntityStringBuilder.setLength(0);
            try {
                variantIdBuilderMethod.invoke(null, this.legacyEntityStringBuilder, entityRenderer, entity);
                variantIdAppended = true;
            }
            catch (Throwable e) {
                ResourceLocation entityId = EntityType.m_20613_((EntityType)entity.m_6095_());
                MinimapLogs.LOGGER.error("Exception while using the variant builder ID method " + iconDefinition.getVariantIdBuilderMethodString() + " defined for " + entityId);
                MinimapLogs.LOGGER.error("If the exception is on another mod's end, suppressing it here could lead to more issues. Please report to appropriate mod devs.", e);
                iconDefinition.setVariantIdBuilderMethod(null);
            }
        } else {
            Method variantOldIdMethod = iconDefinition.getOldVariantIdMethod();
            if (variantOldIdMethod != null && !variantOldIdMethod.equals(EntityIconDefinitions.GET_VARIANT_ID_STRING_METHOD)) {
                this.legacyEntityStringBuilder.setLength(0);
                try {
                    String entityVariantString = (String)variantOldIdMethod.invoke(null, entityRenderer, entity);
                    this.legacyEntityStringBuilder.append(entityVariantString);
                    variantIdAppended = true;
                }
                catch (Throwable e) {
                    ResourceLocation entityId = EntityType.m_20613_((EntityType)entity.m_6095_());
                    MinimapLogs.LOGGER.error("Exception while using the variant ID method " + iconDefinition.getOldVariantIdMethodString() + " defined for " + entityId);
                    MinimapLogs.LOGGER.error("If the exception is on another mod's end, suppressing it here could lead to more issues. Please report to appropriate mod devs.", e);
                    iconDefinition.setOldVariantIdMethod(null);
                }
            }
        }
        if (!variantIdAppended) {
            return null;
        }
        return this.legacyEntityStringBuilder.toString();
    }
}

