/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.waypoints;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.dimension.DimensionType;
import xaero.common.IXaeroMinimap;
import xaero.common.XaeroMinimapSession;
import xaero.common.minimap.waypoints.WaypointWorld;
import xaero.common.minimap.waypoints.WaypointWorldConnectionManager;
import xaero.common.minimap.waypoints.WaypointWorldContainer;
import xaero.common.minimap.waypoints.WaypointsSort;
import xaero.hud.minimap.MinimapLogs;

public class WaypointWorldRootContainer
extends WaypointWorldContainer {
    public boolean configLoaded = false;
    private boolean usingMultiworldDetection = false;
    private boolean ignoreServerLevelId = false;
    private String defaultMultiworldId;
    private boolean teleportationEnabled = true;
    private boolean usingDefaultTeleportCommand = true;
    private String serverTeleportCommandFormat;
    private String serverTeleportCommandRotationFormat;
    private WaypointsSort sortType = WaypointsSort.NONE;
    private boolean sortReversed;
    private boolean ignoreHeightmaps;
    private WaypointWorldConnectionManager subWorldConnections;
    private Map<ResourceKey<Level>, ResourceLocation> dimensionTypeIds;
    private Map<ResourceKey<Level>, DimensionType> dimensionTypes;

    public WaypointWorldRootContainer(IXaeroMinimap modMain, XaeroMinimapSession minimapSession, String key) {
        super(modMain, minimapSession, key, null);
        this.updateConnectionsField(minimapSession);
        this.dimensionTypeIds = new HashMap<ResourceKey<Level>, ResourceLocation>();
        this.dimensionTypes = new HashMap<ResourceKey<Level>, DimensionType>();
    }

    public void updateConnectionsField(XaeroMinimapSession minimapSession) {
        this.subWorldConnections = minimapSession.getWaypointsManager().isMultiplayer(this.key) ? new WaypointWorldConnectionManager() : new WaypointWorldConnectionManager(){

            @Override
            public boolean isConnected(WaypointWorld world1, WaypointWorld world2) {
                return true;
            }

            @Override
            public void save(PrintWriter writer) {
            }
        };
    }

    private File getConfigFile() {
        Path directoryPath = this.getDirectory().toPath();
        try {
            if (!Files.exists(directoryPath, new LinkOption[0])) {
                Files.createDirectories(directoryPath, new FileAttribute[0]);
            }
        }
        catch (IOException e) {
            MinimapLogs.LOGGER.error("suppressed exception", (Throwable)e);
        }
        return directoryPath.resolve("config.txt").toFile();
    }

    public void saveConfig() {
        File configFile = this.getConfigFile();
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(new FileWriter(configFile));
            writer.println("//waypoints config options");
            writer.println("usingMultiworldDetection:" + this.usingMultiworldDetection);
            writer.println("ignoreServerLevelId:" + this.ignoreServerLevelId);
            if (this.defaultMultiworldId != null) {
                writer.println("defaultMultiworldId:" + this.defaultMultiworldId);
            }
            writer.println("teleportationEnabled:" + this.teleportationEnabled);
            writer.println("usingDefaultTeleportCommand:" + this.usingDefaultTeleportCommand);
            if (this.serverTeleportCommandFormat != null) {
                writer.println("serverTeleportCommandFormat:" + this.serverTeleportCommandFormat.replace(":", "^col^"));
            }
            if (this.serverTeleportCommandRotationFormat != null) {
                writer.println("serverTeleportCommandRotationFormat:" + this.serverTeleportCommandRotationFormat.replace(":", "^col^"));
            }
            writer.println("sortType:" + this.sortType.name());
            writer.println("sortReversed:" + this.sortReversed);
            writer.println("");
            writer.println("//other config options");
            writer.println("ignoreHeightmaps:" + this.ignoreHeightmaps);
            this.subWorldConnections.save(writer);
            writer.println("");
            writer.println("//dimension types (DO NOT EDIT)");
            for (Map.Entry<ResourceKey<Level>, ResourceLocation> entry : this.dimensionTypeIds.entrySet()) {
                writer.println("dimensionType:" + entry.getKey().m_135782_().toString().replace(':', '$') + ":" + entry.getValue().toString().replace(':', '$'));
            }
        }
        catch (IOException e) {
            MinimapLogs.LOGGER.error("suppressed exception", (Throwable)e);
        }
        if (writer != null) {
            writer.close();
        }
    }

    public void loadConfig() {
        this.configLoaded = true;
        File configFile = this.getConfigFile();
        if (!configFile.exists()) {
            this.saveConfig();
            return;
        }
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new FileReader(configFile));
            while ((line = reader.readLine()) != null) {
                String valueString;
                String[] args = line.split(":");
                String string = valueString = args.length < 2 ? "" : args[1];
                if (args[0].equals("usingMultiworldDetection")) {
                    this.usingMultiworldDetection = valueString.equals("true");
                    continue;
                }
                if (args[0].equals("ignoreServerLevelId")) {
                    this.ignoreServerLevelId = valueString.equals("true");
                    continue;
                }
                if (args[0].equals("defaultMultiworldId")) {
                    this.defaultMultiworldId = valueString;
                    continue;
                }
                if (args[0].equals("teleportationEnabled")) {
                    this.teleportationEnabled = valueString.equals("true");
                    continue;
                }
                if (args[0].equals("usingDefaultTeleportCommand")) {
                    this.usingDefaultTeleportCommand = valueString.equals("true");
                    continue;
                }
                if (args[0].equals("teleportCommand")) {
                    this.serverTeleportCommandFormat = "/" + valueString.replace("^col^", ":") + " {x} {y} {z}";
                    this.serverTeleportCommandRotationFormat = "/" + valueString.replace("^col^", ":") + " {x} {y} {z} {yaw} ~";
                    continue;
                }
                if (args[0].equals("serverTeleportCommand")) {
                    this.serverTeleportCommandFormat = valueString.replace("^col^", ":") + " {x} {y} {z}";
                    this.serverTeleportCommandRotationFormat = valueString.replace("^col^", ":") + " {x} {y} {z} {yaw} ~";
                    continue;
                }
                if (args[0].equals("serverTeleportCommandFormat")) {
                    this.serverTeleportCommandFormat = valueString.replace("^col^", ":");
                    continue;
                }
                if (args[0].equals("serverTeleportCommandRotationFormat")) {
                    this.serverTeleportCommandRotationFormat = valueString.replace("^col^", ":");
                    continue;
                }
                if (args[0].equals("sortType")) {
                    this.sortType = WaypointsSort.valueOf(valueString);
                    continue;
                }
                if (args[0].equals("sortReversed")) {
                    this.sortReversed = valueString.equals("true");
                    continue;
                }
                if (args[0].equals("ignoreHeightmaps")) {
                    this.ignoreHeightmaps = valueString.equals("true");
                    continue;
                }
                if (args[0].equals("connection")) {
                    String worldKey1 = valueString;
                    if (args.length <= 2) continue;
                    String worldKey2 = args[2];
                    this.subWorldConnections.addConnection(worldKey1, worldKey2);
                    continue;
                }
                if (!args[0].equals("dimensionType")) continue;
                try {
                    this.dimensionTypeIds.put((ResourceKey<Level>)ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(args[1].replace('$', ':'))), new ResourceLocation(args[2].replace('$', ':')));
                }
                catch (Throwable throwable) {}
            }
        }
        catch (FileNotFoundException e) {
            MinimapLogs.LOGGER.error("suppressed exception", (Throwable)e);
        }
        catch (IOException e) {
            MinimapLogs.LOGGER.error("suppressed exception", (Throwable)e);
        }
        if (reader != null) {
            try {
                reader.close();
            }
            catch (IOException e) {
                MinimapLogs.LOGGER.error("suppressed exception", (Throwable)e);
            }
        }
    }

    public boolean isUsingMultiworldDetection() {
        return this.usingMultiworldDetection;
    }

    public void setUsingMultiworldDetection(boolean usingMultiworldDetection) {
        this.usingMultiworldDetection = usingMultiworldDetection;
    }

    public String getDefaultMultiworldId() {
        return this.defaultMultiworldId;
    }

    public void setDefaultMultiworldId(String defaultMultiworldId) {
        this.defaultMultiworldId = defaultMultiworldId;
    }

    public boolean isTeleportationEnabled() {
        return this.teleportationEnabled;
    }

    public void setTeleportationEnabled(boolean teleportation) {
        this.teleportationEnabled = teleportation;
    }

    public boolean isUsingDefaultTeleportCommand() {
        return this.usingDefaultTeleportCommand;
    }

    public void setUsingDefaultTeleportCommand(boolean usingDefaultTeleportCommand) {
        this.usingDefaultTeleportCommand = usingDefaultTeleportCommand;
    }

    public String getServerTeleportCommandFormat() {
        return this.serverTeleportCommandFormat;
    }

    public String getServerTeleportCommandRotationFormat() {
        return this.serverTeleportCommandRotationFormat;
    }

    public void setServerTeleportCommandFormat(String serverTeleportCommandFormat) {
        this.serverTeleportCommandFormat = serverTeleportCommandFormat;
    }

    public void setServerTeleportCommandRotationFormat(String serverTeleportCommandRotationFormat) {
        this.serverTeleportCommandRotationFormat = serverTeleportCommandRotationFormat;
    }

    public WaypointsSort getSortType() {
        return this.sortType;
    }

    public void toggleSortType() {
        this.sortType = WaypointsSort.values()[(this.sortType.ordinal() + 1) % WaypointsSort.values().length];
    }

    public boolean isSortReversed() {
        return this.sortReversed;
    }

    public void toggleSortReversed() {
        this.sortReversed = !this.sortReversed;
    }

    public boolean isIgnoreServerLevelId() {
        return this.ignoreServerLevelId;
    }

    public WaypointWorldConnectionManager getSubWorldConnections() {
        return this.subWorldConnections;
    }

    public boolean isIgnoreHeightmaps() {
        return this.ignoreHeightmaps;
    }

    public void setIgnoreHeightmaps(boolean ignoreHeightmaps) {
        this.ignoreHeightmaps = ignoreHeightmaps;
    }

    public DimensionType getDimensionType(ResourceKey<Level> dimId) {
        DimensionType dimensionType = this.dimensionTypes.get(dimId);
        if (dimensionType == null) {
            ResourceLocation dimensionTypeId = this.dimensionTypeIds.get(dimId);
            if (dimensionTypeId == null) {
                if (dimId == Level.f_46429_) {
                    dimensionTypeId = BuiltinDimensionTypes.f_223543_;
                } else if (dimId == Level.f_46428_) {
                    dimensionTypeId = BuiltinDimensionTypes.f_223542_;
                } else if (dimId == Level.f_46430_) {
                    dimensionTypeId = BuiltinDimensionTypes.f_223544_;
                } else {
                    IntegratedServer integratedServer = Minecraft.m_91087_().m_91092_();
                    if (integratedServer == null) {
                        return null;
                    }
                    ServerLevel serverLevel = integratedServer.m_129880_(dimId);
                    if (serverLevel == null) {
                        return null;
                    }
                    this.dimensionTypes.put(dimId, serverLevel.m_6042_());
                    return serverLevel.m_6042_();
                }
            }
            if ((dimensionType = (DimensionType)Minecraft.m_91087_().f_91073_.m_9598_().m_175515_(Registries.f_256787_).m_7745_(dimensionTypeId)) != null) {
                this.dimensionTypes.put(dimId, dimensionType);
            }
        }
        return dimensionType;
    }

    public double getDimensionScale(ResourceKey<Level> dimId) {
        DimensionType dimType = this.getDimensionType(dimId);
        if (dimType == null) {
            return 1.0;
        }
        return dimType.f_63859_();
    }

    public void updateDimensionType(ClientLevel level) {
        ResourceKey dimId = level.m_46472_();
        ResourceKey dimTypeId = level.m_220362_();
        DimensionType dimType = level.m_6042_();
        if (!Objects.equals(this.dimensionTypeIds.get(dimId), dimTypeId.m_135782_())) {
            this.dimensionTypes.put((ResourceKey<Level>)dimId, dimType);
            this.dimensionTypeIds.put((ResourceKey<Level>)dimId, dimTypeId.m_135782_());
            this.saveConfig();
        }
    }

    @Override
    public WaypointWorldRootContainer getRootContainer() {
        return this;
    }
}

