/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.common.util.collections;

import java.util.Comparator;
import java.util.Iterator;
import net.minecraft.server.level.Ticket;
import net.minecraft.util.SortedArraySet;

public class ChunkTicketSortedArraySet<T>
extends SortedArraySet<Ticket<?>> {
    private long minExpireTime = Long.MAX_VALUE;

    public ChunkTicketSortedArraySet(int initialCapacity) {
        super(initialCapacity, Comparator.naturalOrder());
    }

    public void addExpireTime(long time) {
        if (this.minExpireTime != Long.MAX_VALUE || this.isEmpty()) {
            this.minExpireTime = Math.min(this.minExpireTime, time);
        }
    }

    private void addExpireTimeInternal(long time) {
        this.minExpireTime = Math.min(this.minExpireTime, time);
    }

    public long getMinExpireTime() {
        if (this.minExpireTime == Long.MAX_VALUE) {
            this.recalculateExpireTime();
        }
        return this.minExpireTime;
    }

    public boolean remove(Object object) {
        this.invalidateExpireTime();
        return super.remove(object);
    }

    public void invalidateExpireTime() {
        this.minExpireTime = Long.MAX_VALUE;
    }

    public void recalculateExpireTime() {
        this.minExpireTime = Long.MAX_VALUE;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Ticket c = (Ticket)iterator.next();
            this.addExpireTimeInternal(c.f_9423_ + c.m_9428_().m_9469_());
        }
    }
}

